function [node,ele,gap]=beamsplitter(Ediv)
load node.dat
load elem.dat
NNODE = size(node,1);
nx = node(:,2);
ny = node(:,3);
%*******************************************************************
NELEM = size(elem,1);
ncon = elem(:,[2 3]);
beam_width = elem(:,4);
beam_depth = elem(:,5);
E = elem(:,6);
% gap.dat extraction from elem.dat
%************ make eye-jay****************************************
eye = [];
jay = [];
gap = [];
for ie = 1:NELEM
    for i = 1:NNODE
       if ncon(ie,1) == node(i,1);
            eye = [eye;i];
        end
        if ncon(ie,2) == node(i,1)
            jay = [jay;i];
        end
    end
    % generate gap-up
    if elem(ie,7)~=0 % for non-zero width of gap
        if nx(eye(ie))<=nx(jay(ie))
            x1 = [nx(eye(ie));ny(eye(ie))];
            x2 = [nx(jay(ie));ny(jay(ie))];
        end
        if nx(eye(ie))>nx(jay(ie))
            x2 = [nx(eye(ie));ny(eye(ie))];
            x1 = [nx(jay(ie));ny(jay(ie))];
        end
        theta = atan((x2(2)-x1(2))/(x2(1)-x1(1)));
        rot = [cos(theta) -sin(theta);sin(theta) cos(theta)];
        A = x1+rot*[elem(ie,9);0];% start point+offset
        B = A + rot*[elem(ie,8);elem(ie,7)];
        gap = [gap; 0 A(1) A(2) B(1) B(2) elem(ie,10) theta 1];
    end
    % generate gap down
    if elem(ie,11)~=0 % for non-zero width of gap
        if nx(eye(ie))<=nx(jay(ie))
            x1 = [nx(eye(ie));ny(eye(ie))];
            x2 = [nx(jay(ie));ny(jay(ie))];
        end
        if nx(eye(ie))>nx(jay(ie))
            x2 = [nx(eye(ie));ny(eye(ie))];
            x1 = [nx(jay(ie));ny(jay(ie))];
        end
        theta = atan((x2(2)-x1(2))/(x2(1)-x1(1)));
        rot = [cos(theta) -sin(theta);sin(theta) cos(theta)];
       A = x1+rot*[elem(ie,13);-elem(ie,11)];
        B = A+rot*[elem(ie,12);elem(ie,11)];
        gap = [gap; 0 A(1) A(2) B(1) B(2) elem(ie,14) theta -1];
    end
end
%*********************************************************
%************************ divide element into Ediv elements
Nmax = 100;
%************************ assume Nmax = 100 max 100 nodes
 s = 1; %index of new added node
 ele = []; % this matrix will be appended to elem matrix
for ie = 1:NELEM
    eye = ncon(ie,1); % left node name
    jay = ncon(ie,2); %right node name
    ele = [ele;Nmax+Ediv+s  eye Nmax+s beam_width(ie) beam_depth(ie) E(ie)];
    ele = [ele;Nmax+Ediv+9+s Nmax+s+Ediv-2 jay beam_width(ie) beam_depth(ie) E(ie)];
    % now get the node index in node.dat
    for i = 1:NNODE
        if eye == node(i,1);
            eye = i;
        end
        if jay == node(i,1)
            jay = i;
        end
    end
    nxe = linspace(nx(eye),nx(jay),Ediv+1);  % divide co-ordinates into Ediv
    nye = linspace(ny(eye),ny(jay),Ediv+1);
    for i = 2:Ediv-1
        node = [node; Nmax+s nxe(i) nye(i)]; 
        ele = [ele;Nmax+Ediv+s+1  Nmax+s Nmax+s+1 beam_width(ie) beam_depth(ie) E(ie)];
        s = s+1;
    end
    node = [node; Nmax+s nxe(Ediv) nye(Ediv)];
    s = s+2;
end