function [] = plotgap(gap)
% plotting the electrodes
Ngap = size(gap,1);
gx1 = gap(:,2);
gx2 = gap(:,4); % diagonal point x co-ordinate
gy1 = gap(:,3);
gy2 = gap(:,5); % diagonal point y co-ordinate
for ig = 1:Ngap
    % diagonal ends
    xg = linspace(min(gx1(ig),gx2(ig)),max(gx1(ig),gx2(ig)),5);
    yg = linspace(min(gy1(ig),gy2(ig)),max(gy1(ig),gy2(ig)),5);
    % rotate the diagonal to horizontal base-rectangle diagonal
    theta = gap(ig,7);
    rot = [cos(theta) -sin(theta);sin(theta) cos(theta)];
    A = rot'*[xg;yg];
    [X,Y] = meshgrid(A(1,:),A(2,:));
    % re rotate the meshgrid to the original position
    %X1 = X*cos(theta)-Y*sin(theta);
    Y1 = X*sin(theta)+Y*cos(theta);
    l=size(Y1',1); % size(Y1',1) = 2; for gap-up
    if gap(ig,8) == -1
        l = 1;
    end
    plot(xg,Y1(l,:)','Linewidth',2);
    hold on
 end