%Last Edited 27/11/14
clear all
clc
a=15; % total mesh length in x direction
b=15; % total mesh length in y direction
%If Asymmetric boundary conditions (a not equal to b) result in
%Error , do Ctrl + F 'Asym_Error', follow the
%instructions its at two locations
ua=1; % unit step size required in x direction
ub=1; % unit step size required in y direction
abr=ua/ub;
na=a/ua; % no of steps (or elements) in x direction
nb=b/ub; % no of steps (or elements) in y direction
nnode=(na+1)*(nb+1); % total no of nodes in mesh
nel=na*nb; % total no of elements in mesh
nodeBC=[];
inside_node=[];
BC='OOOO';%Edge BC in CCW manner
img=sqrt(-1); 
w=zeros(nnode,1); % aeros for mode shape matrix
nodes=zeros(na+1,nb+1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOOP FOR GENERATING THE COORDINATES OF EACH NODE %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:(nb+1)
    for i=1:(na+1)
        gcoord((j-1)*(na+1)+i,1)=(i-1)*ua; % X coordinate 
        gcoord((j-1)*(na+1)+i,2)=(j-1)*ub; % Y coordinate
        dqa=(i-1)*ua/a;
        dqb=(j-1)*ub/b;
        if (dqa>0 & dqa<a & dqb>0 & dqb <b)
            dw=sin(dqa*pi*abr)^2*sin(dqb*pi)^2;
             dw=fix(dw*1e5)/1e5;
            w((j-1)*(na+1)+i)=dw;
        end
        % nodes matrix, row no= element no,
        % column value = local nodes in CCW
        if and(i<=na,j<=nb)
            nodes( (j-1)*(na)+i, 1)= (j-1)*(na+1) +i;
            nodes( (j-1)*(na)+i, 2)= (j-1)*(na+1) +i+1;
            nodes( (j-1)*(na)+i, 3)= (j-1)*(na+1) +i+(na+1)+1;
            nodes( (j-1)*(na)+i, 4)= (j-1)*(na+1) +i+(na+1);
        end
        
%         %Screening Constrained Nodes in nodeBC
% Run this 'if ' loop or use perset boundary conditions by preparing matrix
% on lines 59, 60
        if and(gcoord((j-1)*(na+1)+i,1)==0,BC(1)=='O')
            nodeBC=[nodeBC; (j-1)*(na+1)+i];
        elseif and(gcoord((j-1)*(na+1)+i,1)==na*ua,BC(3)=='O')
            nodeBC=[nodeBC; (j-1)*(na+1)+i];
        elseif and(gcoord((j-1)*(na+1)+i,2)==0,BC(2)=='O')
            nodeBC=[nodeBC; (j-1)*(na+1)+i ];
        elseif and(gcoord((j-1)*(na+1)+i,2)==nb*ub,BC(4)=='O')
            nodeBC=[nodeBC; (j-1)*(na+1)+i];
        else
            
            %To Generate Nodes other than Boundary
            inside_node=[inside_node; (j-1)*(na+1)+i];
        end
          %Boudary conditions for preforated BC, its for a,b=10
          % nodeBC=[1,2,3,4,5,6,7,8,9,10,11,20,21,30,31,40,41,45,46,50,51,55,56,60,61,70,71,80,81,90,91,92,93,94,95,96,97,98,99,100];
          %inside_node=[12, 13, 14, 15, 16, 17, 18, 19, 22, 23, 24, 25, 26, 27, 28, 29, 32,33,34,35,36,37,38,39,42,43,44,47,48,49,52,53,54,57,58,59,62,63,64,65,66,67,68,69,72,73,74,75,76,77,78,79,82,83,84,85,86,87,88,89];
        end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Mode shape Vector details
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% w=sin(Norm_gcoord(:,1)*pi).^2.*sin(Norm_gcoord(:,2)*pi).^2;
% w=fix(w*1e5)/1e5;
%Node shape matrix for ploting mode shape if required
%Mode shape nodal matrix for ploting modal shape if required

%%%%%%%%%%%%%%%%%%%%%%%%%%  Asym_Error  %%%%%%%%%%%%%%%%%%%%%%%%%%
%Comment the following loop
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Wnode=zeros(na+1,nb+1);
    for i=1:na+1
        for j=1:nb+1
            Wnode(i,j)=w((i-1)*(na+1)+j);
        end
    end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Building local K1, K2, for each element and global K1_g & K2_g
% First the required Zeros
K1_g=zeros(nnode,nnode);
K2_g=zeros(nnode,nnode);

for j=1:nel %loop over all elements
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%
    % 1  Zita=X dir and Eta=Y dir
    gp=1/sqrt(3);
    
    % ez cantains gauss point values at local nodes in CCW from bottom left
    %First Column Eta Second Column Zeta
    ez=[-gp -gp; gp -gp; gp gp; -gp gp];
    S1=zeros(4);
    S2=zeros(4);
    S3=zeros(4);
    
    for i=1 : 4;
        % Shape Functions matrix, Each row = Shape Function @ i'th row of
        % ez
        N=0.25*[(1-ez(i,1))*(1-ez(i,2));
                (1+ez(i,1))*(1-ez(i,2));
                (1+ez(i,1))*(1+ez(i,2));
                (1-ez(i,1))*(1+ez(i,2));];
            
            %Derivative of Shape Functions at i'th row of ez
            %Every Row is corresponding shape Function
            %first column = Derivative WRT Zita
            %Second column = Derivative WRT Eta
            dN=0.25*[-(1-ez(i,2)) -(1-ez(i,1));
                      (1-ez(i,2)) -(1+ez(i,1));
                      (1+ez(i,2))  (1+ez(i,1));
                     -(1+ez(i,2))  (1-ez(i,1))];
                 
            %Defining Jacobian Determinant and Inverse
            J=dN'*[0 0; ua/a 0; ua/a ub/b; 0 ub/b];
            DetJ= det(J);
            InvJ= [J(2,2) -J(1,2); -J(2,1) J(1,1)]/DetJ;
              %Caution
            if(DetJ<=0)
                display('error: negative jacobian');
            end
            
            S1= S1 + (InvJ(1,:)*dN')'*(InvJ(1,:)*dN')*DetJ;
            S2= S2 + (InvJ(2,:)*dN')'*(InvJ(2,:)*dN')*DetJ;
            S3= S3 + N*N'*DetJ;
            
    end
            K1 = S1 + S2;
            K2 = S3;
    %Loop to grab the K1 and K2 inside the Global K's
    for q=1:4
        for p=1:4
            K1_g(nodes(j, q), nodes(j,p))= K1_g(nodes(j, q), nodes(j,p)) + K1(q,p);
            K2_g(nodes(j, q), nodes(j,p))= K2_g(nodes(j, q), nodes(j,p)) + K2(q,p);
        end
    end
    
end
 K2_gi=img*K2_g;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Requred Zeros
KR_length=length(inside_node);
K1_r=zeros(KR_length);
K2_r=zeros(KR_length);
GSK_r=zeros(KR_length);
F_r=zeros(KR_length,1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for c=1:100 %%% TYEP 2 c=1:1000 c=1:3
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%TYPE 1    swithching sigma for different values
%     switch c
%         case 1
%             sigma=0.1;
%         case 2
%             sigma=1;
%         case 3 
%             sigma=10;
%     end

% Msigma=[1e-12, 1e-11, 1e-10, 1e-9, 1e-8, 1e-7, 1e-6, 1e-5, 1e-4, 1e-3,...
%           1e-2, 1e-1, 1e-0, 1e1, 20, 30, 40, 50, 100, 200]';

% Direct Entry for sigma, 
%   sigma=1e10;
% TYPE 2
% Msigma the matrix of sigma, required becoz sigma is used as scalar
% constant in multiplications
%         Msigma=zeros(100,1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OR Prepare Sigma value matrix, from sigma 0.1 to 100 
        Msigma(c)=(10)^(4*(c-1)/100-1);
        sigma=Msigma(c); %Hear mainkg scalar sigma from vector Msigma
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
     K2_gs=sigma*K2_gi;
     GSK=K1_g+K2_gs;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %Evaluating Golbal Force vector, F(node)
    %F=-(img*sigma*K2_g*w);
      
    F=K2_gs*w;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %for loop to apply bc to K1, K2 and F
    %subscript r for redced matrix
    %result is K1_r, K2_r, F_r, reduced after excluding constrained nodes
    for i=1:KR_length
        for j=1:KR_length
%              K1_r(i,j)=K1_g(inside_node(i),inside_node(j));
%              K2_r(i,j)=K2_g(inside_node(i),inside_node(j));

        GSK_r(i,j)=GSK(inside_node(i),inside_node(j));

        end
        F_r(i,1)=F(inside_node(i));
    end
    
    %Calculating P_r, pressure at unconstrained node
%     P_r=(K1_r+(img*sigma*K2_r))\F_r;
   
     P_r=(GSK_r)\F_r;
    
    
    %Building P matrix for pressure at every node i.e. resubstituting P_r
    %into P
    P=zeros(nnode,1);
    for i=1:KR_length
        P(inside_node(i),1)=P_r(i,1);
    end
    % P_c contains P's of each run in its each column, c'th run c'th column
    P_c(:,c)=P;
    
    %Preparing pbar matrix
    %pbar_c contains al pbars in row direction, 
    %after na rows=> new c=> new pbar
    P_int=zeros(na+1,nb+1);
    for i=1:na+1
        for j=1:nb+1
       %%%%%%%%%%%%%%%%%%%%%%%%%%  Asym_Error  %%%%%%%%%%%%%%%%%%%%%%%%%%
            % Uncomment the following 'if else end conditions'
            % This will ignore out of bound nodes
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
           % if (i-1)*(na+1)+j<nnode
            P_int(i,j)=P((i-1)*(na+1)+j);
            P_int_c((c-1)*(na+1)+i, j)=P((i-1)*(na+1)+j);
            %else 
%             P_int(i,j)=P(nnode);
%             P_int_c((c-1)*(na+1)+i, j)=P(nnode);
            %end
        end
    end
    % Loop through all elements
    F_int=0;
    for i=1:nel
        F_int=F_int+(P(nodes(i,1))+P(nodes(i,2))+P(nodes(i,3))+P(nodes(i,4)))*(((ua/a)*(ub/b))/4);
    end
    F_sp(c,1)=abs(real(F_int));
    F_d(c,1)=abs(imag(F_int));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Ploting Pressure for this sigma

    [damx,damy]=meshgrid(1:nb+1,1:na+1);
    mesh(damx,damy,abs(P_int));
    xlabel('W','fontsize',12,'fontweight','b')
    ylabel('L','fontsize',12,'fontweight','b')
    zlabel('Normalised Pressure','fontsize',12,'fontweight','b')
    title({['Normalise Pressure Distribution for \sigma = ' num2str(sigma) ...
        ];[' Boundary Condition = ' BC];['L = ' num2str(a) 'units'];...
        ['W = ' num2str(b) ' units']},'fontsize',14,'fontweight','b')
    colorbar
    disp('loop for sigma =')
    disp(sigma)
    pause
end


% 
% %The Results
loglog(Msigma,F_sp,'r','linewidth',2);
xlabel('\sigma','fontsize',15,'fontweight','b')
ylabel('F_s','fontsize',15,'fontweight','b')
% axis([0,10e-1,-inf,+inf])
hold on
% pause
loglog(Msigma,F_d,'b','linewidth',2)
xlabel('\sigma','fontsize',15,'fontweight','b')
ylabel('F_d','fontsize',15,'fontweight','b')
% axis([0,10e-1,-inf,+inf])
 legend('spring force F_s','damping force F_d','Location','best')
 title(['Nondimensional Forces vs \sigma for ' BC ' Boundary Condition'],'fontsize',14,'fontweight','b')
 xlabel('\sigma','fontsize',15,'fontweight','b')
 ylabel('F_s & F_d','fontsize',15,'fontweight','b')
