%Code to find the Anisotropy Effective Elastic constants of PolySilicon.
%Here we can find Young's modulus, Shear modulus and Poissons ratio 
%for PolySilicon. 
%Also plots the variations with change in rotation of matrix.This code has
%been written as a part of Mini-project in NE211 course at IISc
%Banglore. code written by Chittipolu Santhosh Kumar
clc
close all
clear all
clf;
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    % Definition of Stiffness Matrix for Si(100) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%stiffness matrix (10^10 dyn/cm^2) or GPa
c1111=165.7; 
c1122=63.9;
c2323=79.6;

%Non-zero componenents of Si stiffness tensor in [100] coordinates
Cc(1,1,1,1)=c1111;
Cc(2,2,2,2)=c1111;
Cc(3,3,3,3)=c1111;
Cc(1,1,2,2)=c1122;
Cc(1,1,3,3)=c1122;
Cc(2,2,1,1)=c1122;
Cc(2,2,3,3)=c1122;
Cc(3,3,1,1)=c1122;
Cc(3,3,2,2)=c1122;
Cc(1,3,1,3)=c2323;
Cc(3,1,1,3)=c2323;
Cc(1,3,3,1)=c2323;
Cc(3,1,3,1)=c2323;
Cc(2,3,2,3)=c2323;
Cc(3,2,2,3)=c2323;
Cc(2,3,3,2)=c2323;
Cc(3,2,3,2)=c2323;
Cc(1,2,1,2)=c2323;
Cc(2,1,1,2)=c2323;
Cc(1,2,2,1)=c2323;
Cc(2,1,2,1)=c2323;
Cpold=zeros(6,6);
Cpnew=zeros(6,6);
N=1000;%number of steps, N>=1000 gives good accuracy 

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % Calculating Young's Modulus Y , Shear Modulus G , and 
      %Poisson's ratio nu of Polysilicon
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
theta=linspace(-pi,pi,N);
Y_angle1=zeros(1,N);
G_angle3=zeros(1,N);
nu_angle2=zeros(1,N);
G1_angle3=zeros(1,N);
nu1_angle2=zeros(1,N);

for st=1:N,
    
 % Transformation matrix
Q=[cos(theta(st)) sin(theta(st)) 0;-sin(theta(st)) cos(theta(st)) 0;0 0 1];
    
    %Calculation of  stiffness tensor in Transformed coordinates
 Ctran=zeros(3,3,3,3);
 for i=1:3,
     for j=1:3,
         for k=1:3,
             for l=1:3,
                 for p=1:3,
                     for q=1:3,
                         for r=1:3,
                             for s=1:3,
   Ctran(i,j,k,l)=Ctran(i,j,k,l)+Q(p,i)*Q(q,j)*Q(r,k)*Q(s,l)*Cc(p,q,r,s);     
                             end
                         end
                     end
                 end
             end
         end
     end
 end
 
Ct=[Ctran(1,1,1,1) Ctran(1,1,2,2) Ctran(1,1,3,3) Ctran(1,1,2,3) ...
    Ctran(1,1,1,3) Ctran(1,1,1,2);Ctran(2,2,1,1) Ctran(2,2,2,2) ...
    Ctran(2,2,3,3) Ctran(2,2,2,3) Ctran(2,2,1,3) Ctran(2,2,1,2);...
    Ctran(3,3,1,1) Ctran(3,3,2,2) Ctran(3,3,3,3) Ctran(3,3,2,3) ...
    Ctran(3,3,1,3) Ctran(3,3,1,2);Ctran(3,2,1,1) Ctran(3,2,2,2) ...
    Ctran(3,2,3,3) Ctran(2,3,2,3) Ctran(2,3,1,2) Ctran(2,3,1,2);...
    Ctran(3,1,1,1) Ctran(3,1,2,2) Ctran(3,1,3,3) Ctran(3,1,2,3) ...
    Ctran(1,3,1,3) Ctran(3,1,1,2);Ctran(2,1,1,1) Ctran(2,1,2,2) ...
    Ctran(2,1,3,3) Ctran(2,1,2,3) Ctran(2,1,1,3) Ctran(1,2,1,2)];
    
    Cpnew=Cpnew+Cpold;
    Cpold=Ct;
     % By definitions
    S=inv(Ct);
    Y_angle1(st)=1/S(1,1);
    nu_angle2(st)=-S(1,2)/S(1,1); % Between two (100)-plane vectors
    nu1_angle2(st)=-S(1,3)/S(1,1);
    G_angle3(st)=1/S(5,5); % Between (100)-plane vector and [001]-vector
    G1_angle3(st)=1/S(6,6);
    
end

Cpnew1=Cpnew/N;
Snew=inv(Cpnew1);

Y = [1/Snew(1,1), 1/Snew(2,2), 1/Snew(3,3)]; % Youngs modulus (GPa)
G = [1/Snew(4,4), 1/Snew(5,5), 1/Snew(6,6)]; % shear modulus (GPa)
nu = - Snew(1:3,1:3)./( [Snew(1,1); Snew(2,2); Snew(3,3)]*ones(1,3));   
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    % Results  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1);
polar(theta,Y_angle1);
%ha=axis;
title('Youngs modulus in GPa');
%axis([0 ha(2) 0 ha(4)]);

figure(2);
polar(theta,nu1_angle2);
hold on
%axis=([-inf inf -inf inf]);
polar(theta,nu_angle2);
hold off
%ha=axis;
title('poisons ratio');
figure(3)
polar(theta,G_angle3);

hold on
polar(theta,G1_angle3);
hold off
%ha=axis;
title('Shear modulus in GPa');
%axis([-inf inf 70 80]);

disp('Youngs modulus of polysilicon in GPa is ');
disp(Y);
disp('Shear modulus of polysilicon in GPa is ');
disp(G);
disp('Poissons Ratio of polysilicon is ');
disp(nu);
