%Code to find the Anisotropy Elastic constants of Silicon in different
%cystal axis directions given three independent constants which crystal
%axes are allinged with <100> family of planes. Here we can find Young's
%modulus, Shear modulus and Poissons ratio for an given plane. This code
%has been written as a part of Mini-project in NE211 course at IISc
%Banglore. code written by Chittipolu Santhosh Kumar
clc
close all
clear all
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    %enter miller indices (h,k,l) of plane 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h=input('enter miller index  and press enter h = ');
k=input('enter miller index  and press enter k = ');
l=input('enter miller index  and press enter l = ');

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
           %calculating directions cosines  along three perpendicular ...
           %directions having common origin 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
E1 =[h k l]; %direction cosines along normal to surface 
e1=E1/norm(E1);%direction cosines along normal to surface 
E2 =[l l -(h+k)]; 
e2=E2/norm(E2);%direction cosines along  surface 
E3 =[-(h*k+k^2+l^2) (l^2+h^2+h*k) l*(h-k)]; 
e3=E3/norm(E3);%direction cosines orthogonal to above both 

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    % Definition of Stiffness Matrix for Si(100) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c11 = 165.7 ; c12 = 63.9 ; c44 = 79.6; %in GPa ,can give constants of any 
%cubic material you wish 
% Stiffness Matrix for Si(100)
C100=[c11 c12 c12 0 0 0; c12 c11 c12 0 0 0; c12 c12 c11 0 0 0; ...
0 0 0 c44 0 0; 0 0 0 0 c44 0;0 0 0 0 0 c44]; % stiffness matrix 
% in (10^10 dyn/cm^2) or GPa
S100=inv(C100);% compliance matrix (cm^2/10^10 dyn)

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    % transformation of Stiffness Matrix and Compliance
                    % matrices
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% for xi'=lix1+mix2+nix3
% where li, mi, ni i = 1,2,3 are direction cosines
% cl1' = cl1 +Cc*(l^4+ m^4+n^4-1)
% c12' = c12+Cc*(l1^2*l2^2+m1^2*m2^2+n1^2*n2^2)
% c44' = c44+Cc*(l2^2*l3^2+m2^2*m3^2+n2^2*n3^2)
% Cc = c11 -c12 -2*c44

Cc= c11 -c12 -2*c44 ;
Ce = zeros(6,6) ; 
Ce(1,1)= Cc; Ce(2,2)= Cc; Ce(3,3)= Cc;
K0 = [ e1.* e1; e2.* e2; e3.* e3; e2.* e3; e1.* e3; e1.* e2]; 
K= K0* K0';
Cnew = C100 + Cc *K - Ce; %  New Stiffness Matrix (GPa)
Snew = inv(Cnew); % New Compliance coefficient Matrix
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Calculating Young's Modulus Y , Shear Modulus G , and 
    %Poisson's ratio nu
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y = [1/Snew(1,1), 1/Snew(2,2), 1/Snew(3,3)]; % Youngs modulus (GPa)
G = [1/Snew(4,4), 1/Snew(5,5), 1/Snew(6,6)]; % shear modulus (GPa)
% Poissons ratio Matrix
nu = -Snew(1:3,1:3)./( [Snew(1,1); Snew(2,2); Snew(3,3)]*ones(1,3));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    % Results  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp('Results');
disp(' youngs modulus for single crystal in GPa is ');
disp(Y);
%figure(1)
%plotmatrix(Y);
disp(' shear modulus for single crystal in GPa is ');
disp(G);
% figure(2)
% plotmatrix(G);
disp(' poissons ratio for single crystal is ');
disp(nu);
%figure(3)
%plotmatrix(nu);
