%%% This code analyses internal forces and displacment of a 3 truss structre
%%% H is Force equilbrium matrix and C is Displacment compatiblity matrix
%%% Written by Ripusudan Agrawal for ME 254 Course Assignment in February 2023
%%% input files
%%% node3d; Data file containig node number and x y z coord.
%%% elem3d; Data file containing elem number, end node no.,cross section,E
%%% in SI 
%%% fixed; Data file giving three fixed nodes for rigid modes surpresion

clearvars;
clc;
clf;

%% input file load and processing
load node3d.dat;
load elem3d.dat;
load fixed.dat;

Nnode=size(node3d,1);
Nelem=size(elem3d,1);
%node cooridnates x y z
nxyz=node3d(:,2:4);
%Elem connetivity with nodes
ncon=elem3d(:,2:3);
%Elem property cross section(SI) and young's modulus(SI)
eprop=elem3d(:,4:5);
%fixed nodes information
fix=fixed(:,2);

%% H and C matrix generation

H=Matrix_gen(nxyz,ncon,Nelem,Nnode);
C=H';
F=null(H);
SoSS=size(F,2);

%% To remove rigid body modes from system, the DoF corresponding to "fixed
%% nodes are removed.
modC=C;
modC(:,[3*fix(1)-2:3*fix(1),3*fix(2)-2:3*fix(2),3*fix(3)-2:3*fix(3)])=[];
%modC(1,:)=[];
%%% replace modC with C for rigid modes visualtion also
modU=null(modC);
Dof=size(modU,2);

%%% adding back fixed nodes in the U matrix
U=zeros(3*Nnode,Dof);
j=1;
for i=1:1:3*Nnode
    if all([3*fix(1)-2:3*fix(1),3*fix(2)-2:3*fix(2),3*fix(3)-2:3*fix(3)]-i)
        U(i,:)=modU(j,:);
        j=j+1;
    end
end

%% Post processing

%% Undeformed figure for visual reference of data files
figure(1);
clf
grid on;
hold on;
view(3);
for i=1:1:Nelem
    en1=ncon(i,1); en2=ncon(i,2);
    plot3([nxyz(en1,1),nxyz(en2,1)],[nxyz(en1,2),nxyz(en2,2)],...
        [nxyz(en1,3),nxyz(en2,3)],':k','LineWidth',2);

end
scatter3(nxyz(:,1),nxyz(:,2),nxyz(:,3),'ok');
text(nxyz(:,1)+0.2,nxyz(:,2)+0.2,nxyz(:,3)+0.2,num2str(node3d(:,1)));
axis equal
xlabel('X');ylabel('Y');zlabel('Z')
hold off
title('Undeformed Configuration');

%%SoSS plot, Blue is element in compression and red is element in tension

figure(2)
clf
grid on
view(3);
sgtitle(['SoSS = ',num2str(SoSS)]);

for i=1:1:SoSS
    subplot(1,round(SoSS/2),i);
    view(3);
    hold on
    grid on
    for j=1:1:Nelem
        en1=ncon(j,1); en2=ncon(j,2);
        if(F(j,i)<0)
            plot3([nxyz(en1,1),nxyz(en2,1)],[nxyz(en1,2),nxyz(en2,2)],...
                [nxyz(en1,3),nxyz(en2,3)],':r','LineWidth',2);
        else
            plot3([nxyz(en1,1),nxyz(en2,1)],[nxyz(en1,2),nxyz(en2,2)],...
                [nxyz(en1,3),nxyz(en2,3)],':b','LineWidth',2);
        end
        text((nxyz(en1,1)+nxyz(en2,1))/2+0.1,(nxyz(en1,2)+nxyz(en2,2))/2+0.1 ...
            ,(nxyz(en1,3)+nxyz(en2,3))/2,num2str(F(j,i)));

    end
    scatter3(nxyz(:,1),nxyz(:,2),nxyz(:,3),'ok');
    axis equal
    xlabel('X');ylabel('Y');zlabel('Z')
    hold off
end


%% Dof Plot, rigid motion included

figure(3)
clf
grid on
view(3);
sgtitle(['DoF = ',num2str(Dof)]);

for i=1:1:Dof
    subplot(2,round(Dof/2),i);
    U(:,i) = U(:,i) / max(abs(U(:,i)));
    view(3);
    hold on
    grid on
    for j=1:1:Nelem
        en1=ncon(j,1); en2=ncon(j,2);
        ui1=3*en1-2; uj1=3*en1-1; uk1=3*en1;
        ui2=3*en2-2; uj2=3*en2-1; uk2=3*en2;

        plot3([nxyz(en1,1)+U(ui1,i),nxyz(en2,1)+U(ui2,i)], ...
            [nxyz(en1,2)+U(uj1,i),nxyz(en2,2)+U(uj2,i)],...
            [nxyz(en1,3)+U(uk1,i),nxyz(en2,3)+U(uk2,i)],'-r','LineWidth',2);

        plot3([nxyz(en1,1),nxyz(en2,1)],[nxyz(en1,2),nxyz(en2,2)],...
            [nxyz(en1,3),nxyz(en2,3)],':k','LineWidth',2);
    end
    %scatter3(nxyz(:,1),nxyz(:,2),nxyz(:,3),'ok');
    axis equal
    xlabel('X');ylabel('Y');zlabel('Z')
    hold off
end