%%% This function generates the force contribution matrix ie H matrix. 
%%% It relates internal forces in elemetnes to external
%%% applied force for 3d trusses.

%%% Written by Ripusudan Agrawal for ME 254 Course Assignment
%%% Takes input nodesc; Matrix containig x y z of all node as row vector
%%% ncon; nodal connectivty matrix for elements with row as element number
%%% Nelem, Nnode; number of elements and nodes

function H=Matrix_gen(nodesc,ncon,Nelem,Nnode)

unit_vector=@(a) a/norm(a); %%function for unit vector along element
H=zeros(3*Nnode,Nelem);

for i=1:1:Nelem

   en1=ncon(i,1);   %node number for end point 1
   en2=ncon(i,2);   %node number for end point 2
   fcomp=unit_vector(nodesc(en2,:)-nodesc(en1,:));  %force unit vector

   %filliing up H matrix
   
   hrow1=3*en1-2;
   hrow2=3*en2-2;
   
   H(hrow1:hrow1+2,i)=fcomp';  %xyz component at respective node
   H(hrow2:hrow2+2,i)=-fcomp';

end
end