% Folded-beam compliant slider elastic pair
% G. K. Ananthasuresh for ME254@IISc, January 2025
%
clear all
clc
% 
L = 2; s = 0.2;
% Plot the initial configuration
figure(1)
clf
plot([0 L], [0 0],'-k'); 
hold on
plot([0 L], [0 0],'ko');
plot([0 L], [s s],'-k'); plot([0 L], [s s],'ko');
plot([0 L], 2*[s s],'-k'); plot([0 L], 2*[s s],'ko');
plot([0 L], 3*[s s],'-k'); plot([0 L], 3*[s s],'ko');
plot([L L], [s 2*s],'-r','LineWidth',3);
plot([0 0], [0 3*s],'-b','LineWidth',3);
plot([L L+s L+s L], [0 0 3*s 3*s],'-g','LineWidth',3);
axis equal
axis([-L/4 1.25*L -2*s 10*s]);
axis off
plot([L L], [-2*s 10*s],'m-.');
% First parallelogram motion
theta = 15*pi/180;
plot([L-L*cos(theta) L], [L*sin(theta) 0],'--k'); 
plot([L-L*cos(theta) L], [L*sin(theta)+s s],'--k'); 
plot([L-L*cos(theta) L], [L*sin(theta)+2*s 2*s],'--k'); 
plot([L-L*cos(theta) L], [L*sin(theta)+3*s 3*s],'--k');
plot(L*(1-cos(theta))*[1 1], [L*sin(theta) L*sin(theta)+3*s],'-b','LineWidth',3);
plot(L-L*cos(theta)*[1 1 1 1],[L*sin(theta) L*sin(theta)+s L*sin(theta)+2*s L*sin(theta)+3*s],'ko');
pause
% Second parallelogram motion half-way through
plot([L-L*cos(theta) L], [L*sin(theta) 0],'--w');  
plot([L-L*cos(theta) L], [L*sin(theta)+3*s 3*s],'--w');
plot([L-L*cos(theta) 2*L-L*cos(theta)], [L*sin(theta) L*sin(theta)],'--k');
plot([L-L*cos(theta) 2*L-L*cos(theta)], [L*sin(theta)+3*s L*sin(theta)+3*s],'--k');
plot([L L+s L+s L], [0 0 3*s 3*s],'-w','LineWidth',3);
plot([L L+s L+s L]+L*(1-cos(theta)), [0 0 3*s 3*s]+L*sin(theta),'-g','LineWidth',3);
plot(L-L*cos(theta)*[1 1],[L*sin(theta) L*sin(theta)+3*s],'ro');
pause
% Second parallelogram motion full-way to compensate the motion in the x-direction
plot([L-L*cos(theta) 2*L-L*cos(theta)], [L*sin(theta) L*sin(theta)],'--w');
plot([L-L*cos(theta) 2*L-L*cos(theta)], [L*sin(theta)+3*s L*sin(theta)+3*s],'--w');
plot([L L+s L+s L]+L*(1-cos(theta)), [0 0 3*s 3*s]+L*sin(theta),'-w','LineWidth',3);
%
plot([L-L*cos(theta) L], [L*sin(theta) 2*L*sin(theta)],'--k');
plot([L-L*cos(theta) L], [L*sin(theta)+3*s 2*L*sin(theta)+3*s],'--k');
plot([L L+s L+s L], [0 0 3*s 3*s]+2*L*sin(theta),'-g','LineWidth',3);
plot(L-L*cos(theta)*[1 1],[L*sin(theta) L*sin(theta)+3*s],'go');
%
% Gradual animation by cordinating the motion of both parallelograms
pause
figure(2)
for i = 1:2,
    for th = [0:theta/10:theta theta:-theta/10:0],
        clf
        plot([L L], [-2*s 10*s],'m-.');
        hold on
        axis equal
        axis([-L/4 1.25*L -2*s 10*s]);
        axis off
        plot([L L+s L+s L], [0 0 3*s 3*s]+2*L*sin(th),'-g','LineWidth',3);
        plot([L-L*cos(th) L], [L*sin(th)+s s],'-k');
        plot([L-L*cos(th) L], [L*sin(th)+2*s 2*s],'-k');
        plot(L*(1-cos(th))*[1 1], [L*sin(th) L*sin(th)+3*s],'-b','LineWidth',3);
        plot([L-L*cos(th) L], [L*sin(th) 2*L*sin(th)],'-k');
        plot([L-L*cos(th) L], [L*sin(th)+3*s 2*L*sin(th)+3*s],'-k');
        pause(0.1)
    end
end



