% XY-decoupler rigid-body mechanism
% G. K. Ananthasuresh, Jan. 2025 for ME254@IISc
clear all
clc
% Inputs
L = 20; s = 1;
% Coordinates of the four building blocks
BB1x = [2*L+s s s -s -s s s];
BB1y = [0 0 s s -s -s 0];
%
BB2x = [L L L+s L+s L-s L-s L];
BB2y = [2*L s s -s -s s s];
%
BB3x = [-L L-s L-s L+s L+s L-s L-s];
BB3y = [0 0 -s -s s s 0] + L;
%
BB4x = [0 0 s s -s -s 0];
BB4y = [-L L-s L-s L+s L+s L-s L-s];
% Plot the initial configuration
figure(1)
clf
plot(BB1x,BB1y,'r-','LineWidth',3);
hold on
plot(BB2x,BB2y,'g-','LineWidth',3);
plot(BB3x,BB3y,'k-','LineWidth',3);
plot(BB4x,BB4y,'b-','LineWidth',3);
% Hatching to show the fixing of BB1
plot([4*s 3*s],[0 -s],'r-');
plot([5*s 4*s],[0 -s],'r-');
plot([6*s 5*s],[0 -s],'r-');
plot([7*s 6*s],[0 -s],'r-');
axis equal
axis([-2.1*L 2.1*L -2.1*L 2.1*L]);
% Animation in the x-direction and back
for i = 1:20,
    plot(BB2x,BB2y,'w-','LineWidth',3);
    plot(BB3x,BB3y,'w-','LineWidth',3);
    BB2x = BB2x + s/2;
    BB3x = BB3x + s/2;
    plot(BB2x,BB2y,'g-','LineWidth',3);
    plot(BB3x,BB3y,'k-','LineWidth',3);
    plot(BB1x,BB1y,'r-','LineWidth',3);
    pause(0.1)
end
for i = 1:20,
    plot(BB2x,BB2y,'w-','LineWidth',3);
    plot(BB3x,BB3y,'w-','LineWidth',3);
    BB2x = BB2x - s/2;
    BB3x = BB3x - s/2;
    plot(BB2x,BB2y,'g-','LineWidth',3);
    plot(BB3x,BB3y,'k-','LineWidth',3);
    plot(BB1x,BB1y,'r-','LineWidth',3);
    pause(0.1)
end
% Animation in the y-direction and back
for i = 1:20,
    plot(BB3x,BB3y,'w-','LineWidth',3);
    plot(BB4x,BB4y,'w-','LineWidth',3);
    BB3y = BB3y + s/2;
    BB4y = BB4y + s/2;
    plot(BB3x,BB3y,'k-','LineWidth',3);
    plot(BB4x,BB4y,'b-','LineWidth',3);
    plot(BB1x,BB1y,'r-','LineWidth',3);
    plot(BB2x,BB2y,'g-','LineWidth',3);
    pause(0.1)
end
for i = 1:20,
    plot(BB3x,BB3y,'w-','LineWidth',3);
    plot(BB4x,BB4y,'w-','LineWidth',3);
    BB3y = BB3y - s/2;
    BB4y = BB4y - s/2;
    plot(BB3x,BB3y,'k-','LineWidth',3);
    plot(BB4x,BB4y,'b-','LineWidth',3);
    plot(BB1x,BB1y,'r-','LineWidth',3);
    plot(BB2x,BB2y,'g-','LineWidth',3);
    pause(0.1)
end
% Animating in both x and y directions equally
for i = 1:20,
    plot(BB2x,BB2y,'w-','LineWidth',3);
    plot(BB3x,BB3y,'w-','LineWidth',3);
    BB2x = BB2x + s/2;
    BB3x = BB3x + s/2;
    plot(BB2x,BB2y,'g-','LineWidth',3);
    plot(BB3x,BB3y,'k-','LineWidth',3);
    %
    plot(BB3x,BB3y,'w-','LineWidth',3);
    plot(BB4x,BB4y,'w-','LineWidth',3);
    BB3y = BB3y + s/2;
    BB4y = BB4y + s/2;
    plot(BB3x,BB3y,'k-','LineWidth',3);
    plot(BB4x,BB4y,'b-','LineWidth',3);
    %
    plot(BB1x,BB1y,'r-','LineWidth',3);
    plot(BB2x,BB2y,'g-','LineWidth',3);
    pause(0.1)
end
for i = 1:20,
    plot(BB2x,BB2y,'w-','LineWidth',3);
    plot(BB3x,BB3y,'w-','LineWidth',3);
    BB2x = BB2x - s/2;
    BB3x = BB3x - s/2;
    plot(BB2x,BB2y,'g-','LineWidth',3);
    plot(BB3x,BB3y,'k-','LineWidth',3);
    %
    plot(BB3x,BB3y,'w-','LineWidth',3);
    plot(BB4x,BB4y,'w-','LineWidth',3);
    BB3y = BB3y - s/2;
    BB4y = BB4y - s/2;
    plot(BB3x,BB3y,'k-','LineWidth',3);
    plot(BB4x,BB4y,'b-','LineWidth',3);
    %
    plot(BB1x,BB1y,'r-','LineWidth',3);
    plot(BB2x,BB2y,'g-','LineWidth',3);
    pause(0.1)
end
% Moving the far end along a circle
r = 0.8*s;
theta = 0:pi/30:2*pi;
deltax = r*cos(theta);
deltay = r*sin(theta);
for i = 1:size(theta,2),
    plot(BB2x,BB2y,'w-','LineWidth',3);
    plot(BB3x,BB3y,'w-','LineWidth',3);
    BB2x = BB2x + deltax(i);
    BB3x = BB3x + deltax(i);
    plot(BB2x,BB2y,'g-','LineWidth',3);
    plot(BB3x,BB3y,'k-','LineWidth',3);
    %
    plot(BB3x,BB3y,'w-','LineWidth',3);
    plot(BB4x,BB4y,'w-','LineWidth',3);
    BB3y = BB3y + deltay(i);
    BB4y = BB4y + deltay(i);
    plot(BB3x,BB3y,'k-','LineWidth',3);
    plot(BB4x,BB4y,'b-','LineWidth',3);
    plot(BB1x,BB1y,'r-','LineWidth',3);
    plot(BB2x,BB2y,'g-','LineWidth',3);
    pause(0.1);
end








