% Geometric Nonlinear Finite element programme for beam problems
% Procedure:Total Lagrangian approach
%
%
% References:
% 1. M.A.Crisfield;"Nonlinear Finite Element analysis of solids and structures", Vol.1,1991.
% 2. J.N. Reddy; "An introduction to Non-linear finite element analysis"
% DATE:26/03/2006
% Modified on 28/02/2024
function [U,GTANS,epsilon,sigma,strain,TSE] = nlfembeam(He,Be,Le,Ee,nx,ny,ncon,NELEM, ...
    NNODE, F, dispID,dispVal,Ine)

global NX NY NNODE_nl NELEM_nl dispID_nl Ee_nl Be_nl He_nl Ae Le_nl Ine_nl ncon_nl  Axxx Dxxx ...
    dispVal_nl fid1 NRT GTANS GFVS GFPS sna0 beta2 alphap op ip 

Ee_nl = Ee;
Be_nl = Be;
He_nl = He;
Le_nl = Le;
Ine_nl = Ine;

Ae =Be.*He;
NRT=0;
format long
% read nodal data
NX=nx;
NY=ny;
%Read element data
NNODE_nl = NNODE;
NELEM_nl = NELEM;
dispID_nl = dispID;
ncon_nl = ncon;
dispVal_nl =dispVal;
Axxx=Ae.*Ee;
Dxxx=Ine.*Ee;
alphap = zeros(NELEM_nl,1);
% Arrange force information into a force vector, F
% Initialization
fid1 = fopen('log_fem.dat','w');
% fid2 = fopen('log_fem2.dat','w');
% fid2 = fopen('log_fem2.dat','w');
%
% Displacement boundary conditions

% j = 0;

beta2=zeros(NELEM_nl,1);

%Define no of load steps
ld_steps=10;
F1=zeros(size(F,1),1);
NRit=100;
Finc=F/ld_steps;
U=zeros(3*NNODE_nl,1);
% flag=1;
scale_factor = 1;
% fc=0;
nn=0;
%UU=zeros(ld_steps,1);PP=zeros(ld_steps,1);
for i=1:ld_steps
    fprintf(fid1,'\nLOAD STEP NO : %g\n',i);
    nn=nn+1;
    F1=F1+Finc;
%     fprintf('\n load step no: %i',i)
    [U,flag,buck,niters,sigma,strain,eigenvalue]=NR(NRit,U,F1);
%     disp(['buck: ',sprintf('%1.6e\t\t',buck),'No. iters for NR:   ',sprintf('%d\t\t',niters)]);   
%     disp(['evalue: ',sprintf('%1.6e\t\t',eigenvalue)]);
    if (flag == 0)
        fprintf('\n Solution is not converged at load step %i \n',i);
        break
    else
        fprintf(fid1,'\n\nNODAL DISPLACEMENTS\n\n');
        fprintf(fid1,'\t NODE NO.\tUx\t\tUy\t\ttheta \n\n');
        for j=1:NNODE_nl
            fprintf(fid1,'\n %g\t%.16f\t%.16f\t %.16f\t',j,U(3*(j-1)+1),U(3*(j-1)+2),U(3*(j-1)+3));
        end
        U1 = scale_factor * U;
        Len=0;     
    end
    if(nn==10)
        nn=0;
    end
    xlabel('X');
    ylabel('Y');
    %    UU(i)=U(77);
    %    PP(i)=F1(77);
    fprintf(fid1,'\n\nINTERNAL NODAL FORCES\n\n');
    fprintf(fid1,'\n\t NODE NO.\tFx\t\tFy\t\tM_z \n\n');
    for kk=1:NNODE_nl
        fprintf(fid1,'%d\t%10f\t%10f\t %10f\n',kk,GFVS(3*(kk-1)+1),GFVS(3*(kk-1)+2),GFVS(3*(kk-1)+3));
    end
%     Uout(i,1) = U(op*3-2);
%     Uout(i,2) = U(op*3-1);
end

[epsilon] = 0;

%% edit by Ripusudan for strain energy element wise
SE=zeros(NELEM_nl,1);

for i=1:1:NELEM_nl
    SE(i)=0.5*He_nl(i)/2*Be_nl(i)*Le_nl(i)/2*sigma(i,:)*strain(i,:)';
end

TSE=sum(SE);

%% end of edit

fprintf(fid1,'\n\tTOTAL NO. OF NEWTON-RAPHSON ITERATIONS:=%g\n',NRT);

fprintf(fid1,'\n*********** ANALYSIS HAS BEEN COMPLETED ***************');
fclose(fid1);
% fclose(fid2);
axis equal

% Function for updating the variables
function [U]  =update(dudef,dispID_nl,U,NNODE_nl)
%Intialise the all the variable increments to  zeros
[sm,sn] = size(dispID_nl);
Ndbc = sn;
du = zeros(3*NNODE_nl,1);
%For the specified displacement boundary conditions intialise du 
for iu=1:Ndbc,
  du(dispID_nl(iu)) = 12345.12345;
end
%Assign incremental displacements to corresponding DOF
iuc = 0;
for iu=1:3*NNODE_nl,
    if du(iu) == 12345.12345
     iuc = iuc+1;
    else
     du(iu) = dudef(iu-iuc);
  end
end
%Assign incremental displacement zero for specified DOF
for iu=1:Ndbc,
  du(dispID_nl(iu)) =0.0;
end
%Incrment the nodal displacements
U=U+du;

function [GTS,GFV,F2,sigma,strain] = gtanst(U,F1)
% F1
% this function forms the tanagent stiffness matrix for the element and assembel it into global Matrix
global NX NY NNODE_nl NELEM_nl dispID_nl Ee_nl Be_nl He_nl Ae Le_nl Ine_nl ncon_nl Axxx Dxxx dispVal_nl fid1 NRT GTANS GFVS GFPS fid2 sna0 beta2 alphap
GTS = zeros(3*NNODE_nl,3*NNODE_nl);GFV=zeros(3*NNODE_nl,1);
sigma=zeros(NELEM_nl,4);
strain=zeros(NELEM_nl,4);
GFPS=GFVS;
nconl_nl=ncon_nl;
format short
for ie=1:NELEM_nl
    eye1 = nconl_nl(ie,1);
    jay = nconl_nl(ie,2);
    x1=NX(eye1);x2=NX(jay);
    z1=NY(eye1);z2=NY(jay);
%    alpha1=alpha(eye1);alpha2=alpha(jay);    
    u1=U(3*(eye1-1)+1);u2=U(3*(jay-1)+1);
    w1=U(3*(eye1-1)+2);w2=U(3*(jay-1)+2);
    theta1=U(3*(eye1-1)+3);theta2=U(3*(jay-1)+3);
    Axx=Axxx(ie);Dxx=Dxxx(ie);
    L0=sqrt((x2-x1)^2+(z2-z1)^2);
    Ln=sqrt((x2+u2-x1-u1)^2+(z2+w2-z1-w1)^2);
    c0=(x2-x1)/L0;
    s0=(z2-z1)/L0;
    c=(x2+u2-x1-u1)/Ln;s=(z2+w2-z1-w1)/Ln;
    sna=c0*s-s0*c;ca=c0*c+s0*s;L=L0;
 %find alpha based on the criteria given in thesis
    if (NRT==1)
         alpha=0;
    else 
       if (sna0(ie)<0)
           alpha =atan2(sna,ca);
           if (alpha >0)
               alpha = -2*pi+alpha;
           end
           ad = abs(abs(alpha) - abs(alphap(ie)));
           if (ad > 4)
               alpha = atan2(sna,ca);
               sna0(ie) = -1*sna0(ie);
           end
       elseif (sna0(ie)>=0)
           alpha =atan2(sna,ca);
           if (alpha < 0)
               alpha = 2*pi + alpha;
           end
           ad = abs(abs(alpha) - abs(alphap(ie)));
           if (ad > 4)
               alpha = atan2(sna,ca);
               sna0(ie) = -1*sna0(ie);
           end
       end  
end
alphap(ie) = alpha;
 u_bar=Ln-L0;theta_b1=theta1-alpha;theta_b2=theta2-alpha;
 B=[-c       -s  0    c      s   0
    -s/Ln  c/Ln  1 s/Ln  -c/Ln   0
    -s/Ln  c/Ln  0 s/Ln  -c/Ln   1];
z=[s -c 0 -s c 0]';r=[-c -s  0 c s 0]';
N = Axx*(u_bar/L+1/15*theta_b1^2-1/30*theta_b1*theta_b2+1/15*theta_b2^2);
M1 = Axx*L*(u_bar/L+1/15*theta_b1^2-1/30*theta_b1*theta_b2+...
    1/15*theta_b2^2)*(2/15*theta_b1-1/30*theta_b2)+Dxx*(4*theta_b1+2*theta_b2)/L;
M2 = Axx*L*(u_bar/L+1/15*theta_b1^2-1/30*theta_b1*theta_b2+...
    1/15*theta_b2^2)*(2/15*theta_b2-1/30*theta_b1)+Dxx*(2*theta_b1+4*theta_b2)/L;
%%%%%%%%% stress calculation through strain term %%%%%%%%%%%%

% interested in nodes only so zeta will be zero at one end and 1 at other




%% Orginal Strain stress calculation at end point 
% % % % j=0;
% % % % for z_hat= [He_nl(ie)/2 -He_nl(ie)/2] ;
% % % % %     z_hat = -Be_nl(ie)/2;
% % % %     zeta=0;     j=j+1;
% % % % strain(ie,j)=(u_bar/L) + 1/15*(theta_b1^2 - (theta_b1*theta_b2)/2+theta_b2^2)+(z_hat/L)*((4-6*zeta)*theta_b1+(2-6*zeta)*theta_b2);
% % % %     zeta=1;     j=j+1;
% % % % strain(ie,j)=(u_bar/L) + 1/15*(theta_b1^2 - (theta_b1*theta_b2)/2+theta_b2^2)+(z_hat/L)*((4-6*zeta)*theta_b1+(2-6*zeta)*theta_b2);
% % % % end
% % % % 
% % % % % epsilon
% % % % % sigma(ie,1) = Ee_nl(ie) * epsilon(ie,1);
% % % % % sigma(ie,2) = Ee_nl(ie) * epsilon(ie,2);
% % % % sigma(ie,1:4) = Ee_nl(ie)*strain(ie,1:4);
% % % % % 1st and 2nd colm of sigma corresponds to upper fiber adn 3,4 corresp to lower fiber of beam 
% % % % %%%%%%%%%%%

%% Edit by Ripusudan Agrawal for stress strain at Gauss points (2d 2 point gauss quadrature) in Feb. 2024
j=0;
for z_hat= [He_nl(ie)/(2*3^0.5) -He_nl(ie)/(2*3^0.5)] 
    zeta=(1+1/3^0.5)/2;     j=j+1;
strain(ie,j)=(u_bar/L) + 1/15*(theta_b1^2 - (theta_b1*theta_b2)/2+theta_b2^2)+(z_hat/L)*((4-6*zeta)*theta_b1+(2-6*zeta)*theta_b2);
    zeta=(1-1/3^0.5)/2;      j=j+1;
strain(ie,j)=(u_bar/L) + 1/15*(theta_b1^2 - (theta_b1*theta_b2)/2+theta_b2^2)+(z_hat/L)*((4-6*zeta)*theta_b1+(2-6*zeta)*theta_b2);
end

% epsilon
% sigma(ie,1) = Ee_nl(ie) * epsilon(ie,1);
% sigma(ie,2) = Ee_nl(ie) * epsilon(ie,2);
sigma(ie,1:4) = Ee_nl(ie)*strain(ie,1:4);
% 1st and 2nd colm of sigma corresponds to upper fiber adn 3,4 corresp to lower fiber of beam 
%%%%%%%%%%%
%% edit ends





KL11 = Axx/L;
% KL12=0;
% KL13=0;
% KL22=4*Dxx/L;
% KL23=2*Dxx/L;
% KL33=KL22;
KL12 = Axx*(2/15*theta_b1-1/30*theta_b2);
KL13 = Axx*(2/15*theta_b2-1/30*theta_b1);
KL22 = Axx*L*(2/15*theta_b1-1/30*theta_b2)^2+2/15*Axx*L*(u_bar/L+1/15*theta_b1^2-1/30*theta_b1*theta_b2+...
      1/15*theta_b2^2)+4*Dxx/L;
KL23 = Axx*L*(2/15*theta_b2-1/30*theta_b1)*(2/15*theta_b1-1/30*theta_b2)-1/30*Axx*L*(u_bar/L+...
       1/15*theta_b1^2-1/30*theta_b1*theta_b2+1/15*theta_b2^2)+2*Dxx/L;
KL33 = Axx*L*(2/15*theta_b2-1/30*theta_b1)^2+2/15*Axx*L*(u_bar/L+...
      1/15*theta_b1^2-1/30*theta_b1*theta_b2+1/15*theta_b2^2)+4*Dxx/L;
 KL21=KL12;KL31=KL13;KL32=KL23;
 KL=[KL11 KL12 KL13
     KL21 KL22 KL23
     KL31 KL32 KL33];
 fint1=[N;M1;M2];
 fint = B'*fint1;
 %%%%%%%% Bending Strain Energy %%%%%%%%%%
%  M = <M1+fy*x>
%  BendingEnergy = <M^2*x/(E*I)>
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 Ktan1=B'*KL*B;
 Ktan2=z*z'*N/Ln;
 Ktan3=(r*z'+z*r')*(M1+M2)/Ln^2;
 Ktan=Ktan1+Ktan2+Ktan3; 

 % Form ID matrix to assemble klocal into the global stiffness matrix, K.
  id1 = 3*(eye1-1) + 1;
  id2 = id1 + 1;
  id3 = id2 + 1;
  id4 = 3*(jay-1) + 1;
  id5 = id4 + 1;
  id6 = id5 + 1;
  %Form Global stiffness matrix
  GTS(id1,id1) = GTS(id1,id1) + Ktan(1,1);
  GTS(id1,id2) = GTS(id1,id2) + Ktan(1,2);
  GTS(id1,id3) = GTS(id1,id3) + Ktan(1,3);
  GTS(id1,id4) = GTS(id1,id4) + Ktan(1,4);
  GTS(id1,id5) = GTS(id1,id5) + Ktan(1,5);
  GTS(id1,id6) = GTS(id1,id6) + Ktan(1,6);
  
  GTS(id2,id1) = GTS(id2,id1) + Ktan(2,1);
  GTS(id2,id2) = GTS(id2,id2) + Ktan(2,2);
  GTS(id2,id3) = GTS(id2,id3) + Ktan(2,3);
  GTS(id2,id4) = GTS(id2,id4) + Ktan(2,4);
  GTS(id2,id5) = GTS(id2,id5) + Ktan(2,5);
  GTS(id2,id6) = GTS(id2,id6) + Ktan(2,6);

  GTS(id3,id1) = GTS(id3,id1) + Ktan(3,1);
  GTS(id3,id2) = GTS(id3,id2) + Ktan(3,2);
  GTS(id3,id3) = GTS(id3,id3) + Ktan(3,3);
  GTS(id3,id4) = GTS(id3,id4) + Ktan(3,4);
  GTS(id3,id5) = GTS(id3,id5) + Ktan(3,5);
  GTS(id3,id6) = GTS(id3,id6) + Ktan(3,6);
  
  GTS(id4,id1) = GTS(id4,id1) + Ktan(4,1);
  GTS(id4,id2) = GTS(id4,id2) + Ktan(4,2);
  GTS(id4,id3) = GTS(id4,id3) + Ktan(4,3);
  GTS(id4,id4) = GTS(id4,id4) + Ktan(4,4);
  GTS(id4,id5) = GTS(id4,id5) + Ktan(4,5);
  GTS(id4,id6) = GTS(id4,id6) + Ktan(4,6);

  GTS(id5,id1) = GTS(id5,id1) + Ktan(5,1);
  GTS(id5,id2) = GTS(id5,id2) + Ktan(5,2);
  GTS(id5,id3) = GTS(id5,id3) + Ktan(5,3);
  GTS(id5,id4) = GTS(id5,id4) + Ktan(5,4);
  GTS(id5,id5) = GTS(id5,id5) + Ktan(5,5);
  GTS(id5,id6) = GTS(id5,id6) + Ktan(5,6);

  GTS(id6,id1) = GTS(id6,id1) + Ktan(6,1);
  GTS(id6,id2) = GTS(id6,id2) + Ktan(6,2);
  GTS(id6,id3) = GTS(id6,id3) + Ktan(6,3);
  GTS(id6,id4) = GTS(id6,id4) + Ktan(6,4);
  GTS(id6,id5) = GTS(id6,id5) + Ktan(6,5);
  GTS(id6,id6) = GTS(id6,id6) + Ktan(6,6);
  
  % Transform local force vector into global internal force vector
  GFV(id1,1)= GFV(id1,1)+ fint(1);
  GFV(id2,1)= GFV(id2,1)+ fint(2);
  GFV(id3,1)= GFV(id3,1)+ fint(3);
  GFV(id4,1)= GFV(id4,1)+ fint(4);
  GFV(id5,1)= GFV(id5,1)+ fint(5);
  GFV(id6,1)= GFV(id6,1)+ fint(6);
 
end
% stress
GTANS=GTS;
GFVS=GFV;
% if (NRT==200)
% %size(GTS)
% eig(GTS)
% pause
% end
% Imposing displacement boundary conditions
% ------------------------------------------
% dispID_nl array contains the dof which are assigned specified values.
[sm,sn] = size(dispID_nl);
Ndbc = sn;

for nd=1:Ndbc
  for nr=1:3*NNODE_nl-nd+1
     GFV(nr) = GFV(nr) - GTS(nr,dispID_nl(nd)-nd+1) * dispVal_nl(nd);
  end
  
GTS = matcut(GTS,dispID_nl(nd)-nd+1);
GFV = veccut(GFV,dispID_nl(nd)-nd+1);
F1=veccut(F1,dispID_nl(nd)-nd+1);
end
F2=F1;

%
function [U,flag,buck,i,sigma,strain,eigenvalue]=NR(NRit,U,F)
global NX NY NNODE_nl NELEM_nl dispID_nl ncon_nl  Axx Dxx dispVal_nl fid1 NRT GTANS GFVS GFPS  sna0 beta2 alphap
F1=F;
ef=1e-5;
 fprintf(fid1,'\t\tFORCE NORMS\t\t\n');
 for i=1:NRit
    NRT=NRT+1;
    [GTS,GFV,F2,sigma,strain] = gtanst(U,F1);
    delR=(F2-GFV);  
    dudef=inv(GTS)*delR;  
%     + 1*eye(size(GTS))
    [U]  =update(dudef,dispID_nl,U,NNODE_nl);
    buck=det(GTS);
    eigenvalue=eig(GTS);
%     cond(GTS)       
% % % % %   
% % % % %     if (NRT==1)
% % % % %          figure(2)
% % % % %         U1=U;
% % % % %        for ip=1:NELEM_nl,
% % % % %             pt1 = ncon_nl(ip,1); pt2 = ncon_nl(ip,2);
% % % % %             dx1 = U1(3*(pt1-1)+1);
% % % % %             dy1 = U1(3*(pt1-1)+2);
% % % % %             dx2 = U1(3*(pt2-1)+1);
% % % % %             dy2 = U1(3*(pt2-1)+2);
% % % % %             hold on 
% % % % %             plot([NX(pt1)+dx1 NX(pt2)+dx2], [NY(pt1)+dy1 NY(pt2)+dy2],'-b');
% % % % %             plot([NX(pt1)+dx1 NX(pt2)+dx2], [NY(pt1)+dy1 NY(pt2)+dy2],'.b');
% % % % %             plot([NX(pt1) NX(pt2)], [NY(pt1) NY(pt2)],'-r');
% % % % %             plot([NX(pt1) NX(pt2)], [NY(pt1) NY(pt2)],'.r');
% % % % %             hold on
% % % % %         end        
% % % % %         xlabel('X');
% % % % %         ylabel('Y');
% % % % %     end
% % % % %     
% % % % %     pause

    if (NRT==1)
        for ie=1:NELEM_nl
            sna0(ie)=-((U(3*(ncon_nl(ie,2)-1)+1)-U(3*(ncon_nl(ie,1)-1)+1))*(NY(ncon_nl(ie,2))-NY(ncon_nl(ie,1)))-...
                        (U(3*(ncon_nl(ie,2)-1)+2)-U(3*(ncon_nl(ie,1)-1)+2))*(NX(ncon_nl(ie,2))-NX(ncon_nl(ie,1))));
        end
    end
%     sna0
%    pause
%check for covergence
    if(i == 1)
        Ef0=(delR'*delR);
        dudef0=dudef;
        delR0=delR;
    else
        if ((delR'*delR) <= ef* Ef0)
             flag=1;
%              fprintf('\n current force norm %2.8g and intial force norm  %2.8g',delR'*delR,Ef0 )
%              fprintf('\n Newton Raphson loop no : %i  \n',i)
             fprintf(fid1,'NRIT:=%g \tCurrent Force Norm:=%g\n',i,delR'*delR);
             break
         end
     end
%      fprintf('\n current force norm %2.8g and intial force norm  %2.8g',delR'*delR,Ef0 )
     if(i == NRit)
         fprintf('\n solution not converged in %g number of iterations \n',NRit)       
         flag=0;
         break
     end
     fprintf(fid1,'NRIT:=%g \tCurrent Force Norm:=%g\n',i,delR'*delR);
 end

 


%%%%%%%%%