% Sample program using the Optimization Toolbox
clc;
clear all
x0 = input('Enter an initial guess for x1 and x2: ');
OPTIONS = OPTIMSET('Display','Iter'); %'MaxIter',20,'MaxFunEvals',100);
[X,FVAL,EXITFLAG,OUTPUT,LAMBDA]=fmincon('fun',x0,[],[],[],[],[],[],'nlcon',OPTIONS);
figure(1);
clf;
 x1=-6:0.01:6;
    x2p=sqrt(25-x1.^2);
    x2m=-sqrt(25-x1.^2);
    x2h=2.5./x1;
    
plot(x1,x2p,'r');
hold on;
plot(x1,x2m,'r');
hold on;
plot(x1,x2h,'k');
axis equal;
plot(X(1), X(2),'g*');
%
px1 = -6:0.1:6; px2 = -6:0.1:6;
[PX1, PX2] = meshgrid(px1,px2);
contour(PX1, PX2, 2*PX1.^2 + 3*PX2.^2,50);
axis([-6 6 -6 6]);
figure(2)
clf
surfc(PX1, PX2, 2*PX1.^2 + 3*PX2.^2);



