%%  This small program was developed by Luzhong Yin, March 18,2002.
%%  University of Pennsylvania.
%%  Contact G. K. Ananthasuresh (gksuresh@seas.upenn.edu) for questions.
%%
clear all;
%% important note: you need to change the input file name for your 
%% own problem in the next line. The file name should follow the
%% "!yinsynF" with an extension .yin. For example, "!yinsynF sample.yin"
!yinsynF strucSample.yin
%% PLEASE DO NOT CHANGE ANYTHIG BELOW THIS LINE UNLESS YOU KNOW WHAT
%% YOU ARE DOING. OF COURSE, YOU CAN CHANGE IT AND PLAY WITH IT IF YOU
%% KNOW WHAT IS GOING ON BELOW.
%
load bou.dat;
% Boundary conditions 
% Node number, dof number, value
%
load ouf.dat;
% Output point information
% x coordinate, y coordinate, direction, sign
%
load inf.dat;
% Input point information
% x coordinate, y coordinate, Force (0) displacement (1),
% magnitude, direction, sign
%
load ijm.dat;
% Node numbers of the designable elements
% node 1, node 2, node 3, node 4
%
load xy0.dat;
% Coordinate of the existing nodes
% x coordinate, y coordinate
%
load y00.dis
dis0=y00;
% dis0 contains the displacement of all the existing nodes (NOT USED)
% x displacement, y displacement
%
load y00.num
um0=y00;
% Element density (fill color value)
% Fill color value for the initial guess
%
load y01.dis
dis=y01;
% dis contains the displacement of all the existing nodes (USE THIS!)
% x displacement, y displacement
%
load y01.num
um=y01;
% Element density (fill color value)
% Fill color value for the final solution
%
[ne,nh]=size(ijm);
j=[1:1:4];
scale=100;
for i=1:ne
    x0(j,i)=xy0(ijm(i,j),1);
    x0(5,i)=x0(1,i);
    y0(j,i)=xy0(ijm(i,j),2);
    y0(5,i)=y0(1,i);
end
for i=1:ne
    x(j,i)=xy0(ijm(i,j),1)+scale*dis(ijm(i,j),1);
    x(5,i)=x(1,i);
    y(j,i)=xy0(ijm(i,j),2)+scale*dis(ijm(i,j),2);
    y(5,i)=y(1,i);
end
figure(1)
clf
hold on;
for i=1:ne
    c=[1-um0(i) 1-um0(i) 1-um0(i)];
    %% Initial density distribution
    fill(x0(:,i),y0(:,i),c) 
end
%% Plot boundary conditions
[nb,i]=size(bou);
i=1;
while i < nb
    hold on;
    switch bou(i,1)==bou(i+1,1)
    case 1 
        plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'s');
        i=i+2;
    case 0
        plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'O');
        i=i+1;
    end
end
hold on;
len=abs(max(max(xy0)-min(xy0)))/10.;
%% Plot input information
[next,i]=size(inf);
for i=1:1:next
    plot([inf(i,2) inf(i,2)+(2-inf(i,5))*len]',[inf(i,3) inf(i,3)+(inf(i,5)-1)*len]','g-');
    hold on;
    if inf(i,6)>0
        switch inf(i,5)
        case 1
            plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g>')
        case 2
            plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g^')
        end
    end
    if inf(i,6)<0
        switch inf(i,5)
        case 1
            plot(inf(i,2),inf(i,3),'g<')
        case 2
            plot(inf(i,2),inf(i,3),'gv')
        end
    end
end
hold on;
%% Plot output information
[nout,i]=size(ouf);
for i=1:1:nout
    plot([ouf(i,1) ouf(i,1)+(2-ouf(i,3))*len]',[ouf(i,2) ouf(i,2)+(ouf(i,3)-1)*len]','r-');
    hold on;
    if ouf(i,4)>0
        switch ouf(i,3)
        case 1
            plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r>')
        case 2
            plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r^')
        end
    end
    if ouf(i,4)<0
        switch ouf(i,3)
        case 1
            plot(ouf(i,1),ouf(i,2),'r<')
        case 2 
            plot(ouf(i,1),ouf(i,2),'rv')
        end
    end
end   
title('Initial Design')
axis equal
axis off
getaxis = axis;
%% Plot the final design
for ip = 1:2,
    if ip == 1, figure(2); clf; hold on; end;
    if ip == 2, figure(3); clf; hold on; end;
    for i=1:ne
        if(um(i)>0.1)  
            c=[1-um(i) 1-um(i) 1-um(i)];
            %% Final density distribution
            fill(x0(:,i),y0(:,i),c) 
            %% Deformed mesh
            if ip == 2, plot(x(:,i),y(:,i),'r'); end;
        end
    end
    title('Final Design')
    axis(getaxis);
    axis equal
    axis off
    %% Plot boundary conditions
    [nb,i]=size(bou);
    i=1;
    while i < nb
        hold on;
        switch bou(i,1)==bou(i+1,1)
        case 1 
            plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'s');
            i=i+2;
        case 0
            plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'O');
            i=i+1;
        end
    end
    %% Plot input information
    [next,i]=size(inf);
    for i=1:1:next
        plot([inf(i,2) inf(i,2)+(2-inf(i,5))*len]',[inf(i,3) inf(i,3)+(inf(i,5)-1)*len]','g-');
        hold on;
        if inf(i,6)>0
            switch inf(i,5)
            case 1
                plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g>')
            case 2
                plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g^')
            end
        end
        if inf(i,6)<0
            switch inf(i,5)
            case 1
                plot(inf(i,2),inf(i,3),'g<')
            case 2
                plot(inf(i,2),inf(i,3),'gv')
            end
        end
    end
    hold on;
    %% Plot output information
    [nout,i]=size(ouf);
    for i=1:1:nout
        plot([ouf(i,1) ouf(i,1)+(2-ouf(i,3))*len]',[ouf(i,2) ouf(i,2)+(ouf(i,3)-1)*len]','r-');
        hold on;
        if ouf(i,4)>0
            switch ouf(i,3)
            case 1
                plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r>')
            case 2
                plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r^')
            end
        end
        if ouf(i,4)<0
            switch ouf(i,3)
            case 1
                plot(ouf(i,1),ouf(i,2),'r<')
            case 2 
                plot(ouf(i,1),ouf(i,2),'rv')
            end
        end
    end
end




