% Truss topology optimization 
clc
clear all
global La Ea nx ny ncon NELEM NNODE F dispID Vstar

Lx = 2.0;       % Length of the design domain in the x-direction
Ly = 1.0;       % Length of the design domain in the y-direction
nNodex = 4;     % Number of nodes along the x-driection
nNodey = 4;     % Number of nodes along the y-direction
% Generate the nodes
NNODE = 0;
for j = 1:nNodey,
    for i = 1:nNodex,
        NNODE = NNODE + 1;
        nx(NNODE) = Lx*(i-1);
        ny(NNODE) = Ly*(j-1);
    end
end
% Generate the exuastive set of truss elements connecting every pair of nodes
NELEM = 0;
for i = 1:NNODE,
    for j = i:NNODE,
        if i ~= j,
            NELEM = NELEM + 1;
            ncon(NELEM,:) = [i j];
        end
    end
end
% Identify and remove overlapping elements based on slopes and lengths
for i = 1:NELEM,
    eye = ncon(i,1); jay = ncon(i,2);
    Length(i) = sqrt( (nx(eye)-nx(jay))^2 + (ny(eye)-ny(jay))^2 );
    Slope(i) = atan2((ny(jay)-ny(eye)), (nx(jay)-nx(eye)));
end
uslope = unique(Slope);
ncon(:,3) = zeros(NELEM,1);
for i = 1:size(uslope,2),
    temp = find(Slope==uslope(i));
    minL = min(Length(temp));
    for j = 1:size(temp,2),
        if Length(temp(j)) > minL,
            ncon(temp(j),3) = 1;
        end
    end
end
nconold = ncon;
clear ncon
NELEMold = NELEM;
NELEM = 0;
for i = 1:NELEMold,
    if nconold(i,3) == 0,
       NELEM = NELEM + 1;
       ncon(NELEM,:) = [nconold(i,1) nconold(i,2)];
       eye = ncon(NELEM,1); jay = ncon(NELEM,2);
       L(NELEM) = sqrt( (nx(eye)-nx(jay))^2 + (ny(eye)-ny(jay))^2 );
   end
end
% Plot to test the ground structure
figure(1)
clf
for i = 1:NELEM,
    eye = ncon(i,1); jay = ncon(i,2);
    plot([nx(eye) nx(jay)], [ny(eye) ny(jay)],'-r');
    hold on
end

F = zeros(2*NNODE,1);   % Initialize load vector
% Specify loads at required degrees of freedom
F(2*(nNodex+1)) = -1;        % Downward load at bottom right corner
Ub = ones(NELEM,1)*min([Lx/nNodex Ly/nNodey])*0.2;
Lb = ones(NELEM,1)*min([Lx/nNodex Ly/nNodey])*1e-4;
Y = ones(NELEM,1)*150E9;% Young's modulus
Vstar = Lx*Ly*0.01*0.3;

A0 = Vstar/sum(L)*ones(NELEM,1);
La = L;
Ea = Y;

dispID = [1 2 3 4];
dispID = sort(dispID);

% 
[u,Rdisp,P,Ksing,SE,SEgrad] = ...
    femtruss(A0, La, Ea, nx, ny, ncon, NELEM, NNODE, F, dispID);
