%%
%% Post-processing for PennSyn, a topology optimization program for structures and
%% compliant mechanisms
%% This program was developed by Dr. Luzhong Yin, the post-doc in
%% G. K. Ananthasuresh's group at University of Pennsylvania, Philadelphia 
%% in March 2002.
%%
clear all;
%% Type your yinput file name here after "!pennsyn".
!pennsynF samplecm.yin
%% bou.dat     ------> fixed boundary information
load bou.dat;
%% ouf.dat     ------> output displacement information
load ouf.dat;
%% inf.dat     ------> input load information 
load inf.dat;
%% ijm.dat     ------> element connetion information
load ijm.dat;
%% xy0.dat     ------> node definition data
load xy0.dat;
%% y00.dis     ------> initial node displacements  
load y00.dis
%% y00.num     ------> initial design material densities
dis0=y00;
%% y01.dis     ------> final node displacements  
load y00.num
%% y01.num     ------> final design material densities
um0 = y00;
load y01.dis
dis = y01;
load y01.num
um = y01;
[ne,nh] = size(ijm);

j=[1:1:4];
scale = 300;    % Scale factor for plotting the deformed configuration
for i=1:ne
    x0(j,i)=xy0(ijm(i,j),1);
    x0(5,i)=x0(1,i);
    y0(j,i)=xy0(ijm(i,j),2);
    y0(5,i)=y0(1,i);
end
for i=1:ne
    x(j,i)=xy0(ijm(i,j),1)+scale*dis(ijm(i,j),1);
    x(5,i)=x(1,i);
    y(j,i)=xy0(ijm(i,j),2)+scale*dis(ijm(i,j),2);
    y(5,i)=y(1,i);
end

figure(1)
clf
hold on;
for i=1:ne
    c = [1-um0(i) 1-um0(i) 1-um0(i)];
    %%%%%%% Initial density distribution
    fill(x0(:,i),y0(:,i),c) 
end
%%%%%% Plot boundary condition
[nb,i] = size(bou);
i = 1;
while i < nb
    hold on;
    switch bou(i,1) == bou(i+1,1)
    case 1 
        plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'s');
        i = i + 2;
    case 0
        plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'O');
        i = i + 1;
    end
end
hold on;
len = abs(max(max(xy0)-min(xy0)))/10.;
%%%%%% Plot input information
[next,i]=size(inf);
for i=1:1:next
    plot([inf(i,2) inf(i,2)+(2-inf(i,5))*len]',[inf(i,3) inf(i,3)+(inf(i,5)-1)*len]','g-');
    hold on;
    if inf(i,6)>0
        switch inf(i,5)
        case 1
            plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g>')
        case 2
            plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g^')
        end
    end
    if inf(i,6)<0
        switch inf(i,5)
        case 1
            plot(inf(i,2),inf(i,3),'g<')
        case 2
            plot(inf(i,2),inf(i,3),'gv')
        end
    end
end
hold on;
%%%%%plot output information
[nout,i]=size(ouf);
for i=1:1:nout
    plot([ouf(i,1) ouf(i,1)+(2-ouf(i,3))*len]',[ouf(i,2) ouf(i,2)+(ouf(i,3)-1)*len]','r-');
    hold on;
    if ouf(i,4)>0
        switch ouf(i,3)
        case 1
            plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r>')
        case 2
            plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r^')
        end
    end
    if ouf(i,4)<0
        switch ouf(i,3)
        case 1
            plot(ouf(i,1),ouf(i,2),'r<')
        case 2 
            plot(ouf(i,1),ouf(i,2),'rv')
        end
    end
end

title('Initial Design')
axis equal
axis off

getaxis = axis;

%%%%%%%% plot the final design
for ic = 1:2,
    if ic == 1, 
        figure(2); 
        clf
        hold on
    else 
        figure (3); 
        clf
        hold on
    end
    for i=1:ne
        if(um(i)>0.1)  
            c=[1-um(i) 1-um(i) 1-um(i)];
            if ic == 1, 
                %%%%%%%final density distribution
                fill(x0(:,i),y0(:,i),c) 
            else
                %%%%%%%deformed mesh
                fill(x(:,i),y(:,i),c)
            end
        end
    end
    if ic == 1,
        title('Topology solution');
    else
        title('Deformed configuration');
    end
    axis(getaxis);
    axis equal
    axis off
    %break % Added by Suresh
    %%%%%%plot boundary condition
    [nb,i]=size(bou);
    i=1;
    while i < nb
        hold on;
        switch bou(i,1)==bou(i+1,1)
        case 1 
            plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'s');
            i=i+2;
        case 0
            plot(xy0(bou(i,1),1),xy0(bou(i,1),2),'O');
            i=i+1;
        end
    end
    %%%%%%plot input information
    [next,i]=size(inf);
    for i=1:1:next
        plot([inf(i,2) inf(i,2)+(2-inf(i,5))*len]',[inf(i,3) inf(i,3)+(inf(i,5)-1)*len]','g-');
        hold on;
        if inf(i,6)>0
            switch inf(i,5)
            case 1
                plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g>')
            case 2
                plot(inf(i,2)+(2-inf(i,5))*len,inf(i,3)+(inf(i,5)-1)*len,'g^')
            end
        end
        if inf(i,6)<0
            switch inf(i,5)
            case 1
                plot(inf(i,2),inf(i,3),'g<')
            case 2
                plot(inf(i,2),inf(i,3),'gv')
            end
        end
    end
    hold on;
    %%%%%plot output information
    [nout,i]=size(ouf);
    for i=1:1:nout
        plot([ouf(i,1) ouf(i,1)+(2-ouf(i,3))*len]',[ouf(i,2) ouf(i,2)+(ouf(i,3)-1)*len]','r-');
        hold on;
        if ouf(i,4)>0
            switch ouf(i,3)
            case 1
                plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r>')
            case 2
                plot(ouf(i,1)+(2-ouf(i,3))*len,ouf(i,2)+(ouf(i,3)-1)*len,'r^')
            end
        end
        if ouf(i,4)<0
            switch ouf(i,3)
            case 1
                plot(ouf(i,1),ouf(i,2),'r<')
            case 2 
                plot(ouf(i,1),ouf(i,2),'rv')
            end
        end
    end
end





