function NodeFile();
global Nx Ny Lb Lw Ex Ey s node elem NNODES NELEM NSQUARENODE ElemBoxCoords Lx Ly

%This function writes the node file for the shape, which includes 
%node number, x and y coordinates, connector type and angle of rotation

%*************************************************************************************************************************************
%NODE FILES%
%*************************************************************************************************************************************

% Square node number, x and y coordinates
NSQUARENODE = Nx*Ny;
SquareNodeNumber = (j-1)*Nx + i;
for j = 1:1:Ny,  %variable = starting place (1) : increment (1) : ending place (Ny as specified above)
    for i = 1:1:Nx,
      node((j-1)*Nx+i,1) = (j-1)*Nx + i;     % number 1 to maximum node  ,1 =first column in the matrix
      node((j-1)*Nx+i,2) = (i-1)*Lb;          % x value                   ,2 = 2nd column in matrix
      node((j-1)*Nx+i,3) = (j-1)*Lb;          % y value    
      node((j-1)*Nx+i,6) = 1;                 % 0 is placed here to say the node does not exist
   end
end

%diagonal node numbers, x and y coordinates
NdiagonalNODE = Ex*Ey;
for j = 1:1:Ey,  %variable = starting place (1) : increment (1) : ending place (Ny as specified above)
    for i = 1:1:Ex,
      node(NSQUARENODE + ((j-1)*Ex+i),1) = NSQUARENODE+((j-1)*Ex+i);     % number 1 to maximum node  ,1 =first column in the matrix
      node(NSQUARENODE + ((j-1)*Ex+i),2) = ((i-1)*Lb) + Lb/2;                  % x value                   ,2 = 2nd column in matrix
      node(NSQUARENODE + ((j-1)*Ex+i),3) = ((j-1)*Lb) + Lb/2;                  % y value
      node(NSQUARENODE + ((j-1)*Ex+i),6) = 1;									%the element exists	
      
   end
end

NNODES = NSQUARENODE + NdiagonalNODE;

%************************************************************************************************************************************
%NODE FILE CONNECTOR TYPES AND ANGLES%
%*************************************

%WHITE CONNECTORS%
%(all will be labeled as white connectors and then specific ones - sides and corners
% will be changed afterwards)

for NodeNumber=1:(Nx*Ny)+(Ex*Ey),  
      node(NodeNumber,4) = 1;        % connector type
      node(NodeNumber,5) = 0;        % angle 
end



%YELLOW CONNECTORS%

%yellow connectors (type 2) at 180 degree angle (bottom row)
for j = 1,
    for i = 2:Ex,
        node(((j-1)*Ex+i),4) = 2;          % connector type
        node(((j-1)*Ex+i),5) = 180;        % angle 
    end
end    
%yellow connectors (type 2) at 0 degree angle (top row)
for i = 1:Ex,
    node(Nx*Ey+i,4) = 2;          % connector type
    node(Nx*Ey+i,5) = 0;          % angle 
end
%yellow connectors (type 2) at 90 degree angle (left side)
for i = 1,
    for j = 1:Ey,
        node(j*Nx + 1,4) = 2;          % connector type
        node(j*Nx + 1,5) = 90;          % angle 
        i = i+1;
    end
end    
%yellow connectors (type 2) at 270 degree angle (right side)
for i = Ny,
    for j = 2:Ey,
        node(j*Nx,4) = 2;          % connector type
        node(j*Nx,5) = 270;         % angle 
        i = i+1;
    end
end    

%RED CONNECTORS% (type 3)

%bottom left corner (90 degrees)
node(1,4) = 3;               % connector type
node(1,5) = 90;              % angle 
%bottom right corner (180 degrees)
node(Nx,4) = 3;              % connector type
node(Nx,5) = 180;            % angle 
%top left corner (0 degrees)
node((Nx*Ey)+1,4) = 3;  % connector type
node((Nx*Ey)+1,5) = 0;  % angle 
%top right corner (270 degrees)
node((Ny*Nx),4) = 3;        % connector type
node((Ny*Nx),5) = 270;      % angle 

