% Size optimization of a truss using fmincon 
% ME 260; August 2025; IISc, Bengaluru; G. K. Ananthasuresh
%
% Objective function: Strain enerrgy (to be minimized)
% Volume constraint:
%
% House-keeping commands
clear all
clc
global L E nx ny ncon NELEM NNODE F dispID
%
% Load data and save into appropriate arrays
load node.dat
NNODE = size(node,1);
for i = 1:NNODE,
    nx(i) = node(i,2);
    ny(i) = node(i,3);
end
load elem.dat
NELEM = size(elem,1);
for i = 1:NELEM,
    ncon(i,1) = elem(i,2);
    ncon(i,2) = elem(i,3);
    A(i) = elem(i,4);
    E(i) = elem(i,5);
    lx = nx(ncon(i,2)) - nx(ncon(i,1));
    ly = ny(ncon(i,2)) - ny(ncon(i,1));
    L(i) = sqrt(lx^2+ly^2);
end
load forces.dat
F = zeros(2*NNODE,1);
for i = 1:size(forces,1),
    forceID = 2*(forces(i,2)-1) + forces(i,3);
    F(forceID) = forces(i,4);
end
load dispbc.dat
for i = 1:size(dispbc,1),
    dispID(i) = 2*(dispbc(i,2)-1) + dispbc(i,3);
end
dispID = dispID';
Vstar =4.1623E-4; % A*L';
%
% Call fmincon
%  X = fmincon(FUN,X0,A,B,Aeq,Beq,LB,UB,NONLCON)
A0 = A; ALB = 0.1*A; AUB = 2*A;
options = optimoptions('fmincon','StepTolerance',1E-10,'OptimalityTolerance', 1e-9,'Display','iter');
[Aopt,FVAL,EXITFLAG,OUTPUT,LAMBDA,GRAD,HESSIAN] = fmincon('SEtruss',A0,[],[],L,Vstar,ALB,AUB,[],options);
lambda = LAMBDA.eqlin;
% Call FEA with optimized A
[u,Rdisp,P,Ksing,SE,SEgrad] = ...
    femtruss(Aopt, L, E, nx, ny, ncon, NELEM, NNODE, F, dispID);
% Internal forces
f = sqrt(P(:,1).^2+P(:,2).^2).*P(:,5);
SE
MaxwellC = L*f
%
% Plotting truss and its deformation
figure(1)
clf
% SF = scale factor to show displacements
SF = 100;
for i = 1:NELEM,
    eye = ncon(i,1);
    jay = ncon(i,2);
    plot([nx(eye) nx(jay)],[ny(eye) ny(jay)],'-k');
    hold on
    plot([nx(eye) nx(jay)],[ny(eye) ny(jay)],'ko');
    dx1 = u(2*eye-1)*SF;
    dx2 = u(2*jay-1)*SF;
    dy1 = u(2*eye)*SF;
    dy2 = u(2*jay)*SF;
    plot([nx(eye)+dx1 nx(jay)+dx2],[ny(eye)+dy1 ny(jay)+dy2],'-r');
    plot([nx(eye)+dx1 nx(jay)+dx2],[ny(eye)+dy1 ny(jay)+dy2],'ro');
end
axis equal
grid

