% Demonstration of fmincon and Karush-Kuhn-Tucker conditions 
% for size-optimizing a two-bar truss 
% ME 260; August 2022; IISc, Bengaluru; G. K. Ananthasuresh
%
% Objective function: Strain energy
% Equality constraint: Volume constraint
%
% House-keeping commands
clear all
clc
global A1 A2 L1 L2 E
% Data pertaining to the problem
h = 0.7; % Height of the fixed pivots of the bars from the force-application point [m]
F = 1000; % Force [N]
E = 210E9; % Young's modulus
A1 = 50E-6; % Area of c/s of Bar 1 [m^2]
A2 = 50E-6; % Area of c/s of Bar 2 [m^2]
Vstar = 70E-6; % m^3
% Plot the surface and contour of the strain energy 
figure(1)
clf
[theta,phi] = meshgrid(30:1:100,30:1:100); % Area of c/s in mm^2
p1 = F*cos(phi*pi/180)./sin((theta+phi)*pi/180);
p2 = F*cos(theta*pi/180)./sin((theta+phi)*pi/180);
L1 = h./sin(theta*pi/180);
L2 = h./sin(phi*pi/180);
SE = (p1.^2.*L1/A1*1E-6 + p2.^2.*L2/A2*1E-6)/2/E;
surfc(theta,phi,SE*1E12);
hold on
xlabel('Theta');
ylabel('Phi');
zlabel('Strain energy');
% Plot the contours of SE 
figure(2)
clf
% f
[C, hndl] = contour(Theta,Phi,SE*1E12);
clabel(C);
axis equal
axis square
hold on
xlabel('Theta');
ylabel('Phi');
% Volume constraint
xA1 = linspace(1,100,100);
yA2 = (-xA1*L1 + Vstar)/L2;
plot(xA1,yA2,'-k','LineWidth',2);
grid

% % Call fmincon
% x0 = [10; 10];
% [x,FVAL,EXITFLAG,OUTPUT,LAMBDA,GRAD,HESSIAN] = fmincon('SE',x0,[],[],[L1 L2],[Vstar],[0 0],[]);
% lambda = LAMBDA.eqnonlin;
% % Plot the optimum point on the contour map
% plot(x(1),x(2),'r.','MarkerSize',20);
% grid