% Demonstration of fmincon and Karush-Kuhn-Tucker conditions 
% for size-optimizing a two-bar truss 
% ME 260; August 2022; IISc, Bengaluru; G. K. Ananthasuresh
%
% Objective function: Strain energy
% Equality constraint: Volume constraint
%
% House-keeping commands
clear all
clc
global p1 p2 L1 L2 E
% Data pertaining to the problem
h = 0.7; % Height of the fixed pivots of the bars from the force-application point [m]
F = 1000; % Force [N]
E = 210E9; % Young's modulus
theta = 120*pi/180; % Inclination of Bar 1
phi = 45*pi/180; % Inclination of Bar 2
L1 = h/sin(theta);
L2 = h/sin(phi);
Vstar = (L1+L2)*50; % m^3*1E-6
p1 = abs(F*cos(phi)/sin(theta+phi));
p2 = abs(F*cos(theta)/sin(theta+phi));
% Plot the surface and contour of the strain energy 
figure(1)
clf
[A1,A2] = meshgrid(1:1:100, 1:1:100); % Area of c/s in mm^2
SE = (p1^2*L1./A1*1E-6 + p2^2*L2./A2*1E-6)/2/E;
surfc(A1,A2,SE*1E12);
hold on
xlabel('A1');
ylabel('A2');
zlabel('Strain energy');
% Plot the contours of SE 
figure(2)
clf
% f
[C, hndl] = contour(A1,A2,SE*1E12,[0.1:0.01:0.2 0.225 0.25 0.3:0.1:0.6 0.8 1]);
hold on
clabel(C);
axis equal
axis square
hold on
xlabel('A1');
ylabel('A2');
% Volume constraint
xA1 = linspace(1,100,100);
yA2 = (-xA1*L1 + Vstar)/L2;
plot(xA1,yA2,'-k','LineWidth',2);
grid

% Call fmincon
x0 = [10; 10];
[x,FVAL,EXITFLAG,OUTPUT,LAMBDA,GRAD,HESSIAN] = fmincon('SE',x0,[],[],[L1 L2],[Vstar],[0 0],[]);
lambda = LAMBDA.eqnonlin;
% Plot the optimum point on the contour map
plot(x(1),x(2),'r.','MarkerSize',20);
grid
% 
figure(2)
[C, hndl] = contour(A1,A2,SE*1E12,[FVAL:0.0001:FVAL+0.0001]);
set(hndl,'LineWidth',2)