% Demonstration of fmincon and Karush-Kuhn-Tucker conditions
% ME 256; January 2017; IISc, Bengaluru; G. K. Ananthasuresh
%
% Objective function: f = 1/x + 1/y
% Inequality constraint 1: g1 = 4*x - 2y - 4 <= 0 
% Inequality constraint 2: g2 = 2x + y - 6 <= 0
%
% House-keeping commands
clear all
clc
% Plot the surface and contour of f
figure(1)
clf
[X,Y] = meshgrid(0.1:.2:4, 0.1:.2:4);
Z = 1./X + 1./Y;
surfc(X,Y,Z);
hold on
xlabel('x');
ylabel('y');
zlabel('f = 1/x + 1/y');
% Plot the contours of f and curves of h and g
figure(2)
clf
% f
[C, hndl] = contour(X,Y,Z,[0.5 0.6 0.7 0.8 0.9714 1.25 1.5 2 3 5]);
clabel(C);
axis equal
hold on
axis([0 4 0 4]);
xlabel('x');
ylabel('y');
% h
gx1 = linspace(0,3.5,100);
gy1 = 2*gx1 - 2;
plot(gx1,gy1,'--g','LineWidth',2);
gx2 = linspace(0,3.5,10);
gy2 = -2*gx2 + 6;
plot(gx2,gy2,'-k','LineWidth',2);
% Call fmincon
x0 = [1; 1];
[x,FVAL,EXITFLAG,OUTPUT,LAMBDA,GRAD,HESSIAN] = fmincon('obj2',x0,[4 -2; 2 1],[4; 6],[],[],[],[]);
lambda = LAMBDA.eqnonlin;
% Plot the optimum point on the contour map
plot(x(1),x(2),'r.','MarkerSize',20);
grid