% HW 1, Prob. 2b, 2022
% Shape optimization of a three-bar truss
clear all
clc
% Data
theta = atan2(1,3); 
F = 100; % N
E = 210E9; % Pa
A1 = 49.93E-6; % m^2
A2 = A1;
A3 = 47.36E-6; % m^2
% Processing of data
s = linspace(100,300,100);
phi = atan2(50,s-150);
L1 = sqrt(50^2+150^2)/1000; % m
L2 = sqrt(50^2+(s-150).^2)/1000; % m
L3 = s/1000; % m
P1 = F*cos(phi)./sin(theta+phi);
P2 = F*cos(theta)./sin(theta+phi);
P3 = P1*cos(theta);
% Quantities to be plotted
gvol = A1*L1 + A2*L2 + A3*L3 - 30000E-9;
SE = (P1.^2.*L1/A1 + P2.^2.*L2/A2 + P3.^2.*L3/A3)/(2*E);
% Plotting
figure(1)
clf
plotyy(s,SE,s,gvol*1E6);
grid
xlabel('s(mm)')
legend('SE(J)','Volg(mm^3)')

