%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This m-file forms the H matrix that relates internal forces in truss
% elments to the external forces applied at the vertices, for 2D trusses. 
% G.K. Ananthasuresh for ME 851 class in 2013, Sep, IIT-Kanpur.
% Inputs:
% nx    --> A vector containing the X-coordinates of all the nodes
% ny    --> A vector containing the Y-coordinates of all the nodes
% ncon  --> A matrix containing the nodal-connectivity of all the elements
% NELEM --> Number of truss members
% NNODE --> Number of vertices
% Output:
% H    --> The H matrix of size 2n (n = number of vertices) by m (number 
% of truss members).
%
function [H] = ...
         getHmatrix(nx, ny, ncon, NELEM, NNODE)

H = zeros(2*NNODE, NELEM);     % Initialize the H matrix

for ie=1:NELEM,
  eye = ncon(ie,1);
  jay = ncon(ie,2);

% Find sin(theta) and cos(theta) of the truss element.
  theta = atan2( (ny(jay)-ny(eye)), (nx(jay)-nx(eye)) ); 
  c = cos(theta); s = sin(theta);
% Fill in respective entries in the H matrix
  id1 = 2*(eye-1) + 1;
  id2 = id1 + 1;
  id3 = 2*(jay-1) + 1;
  id4 = id3 + 1;
  H(id1,ie) = c;
  H(id2,ie) = s;
  H(id3,ie) = - c;
  H(id4,ie) = -s;
end


