function ElementFile();
global Nx Ny Lb Lw Ex Ey s node elem NNODES NELEM NSQUARENODE ElemBoxCoords Lx Ly flag SE U

%to also have last column of element file contain the young's modulus, the variable representing it,
% YM, has to be entered above in the parenthesesm and in the main program, it has to be defined along
%with the length, NX, NY, etc.  THen just reactivate the lines below containing the 5th column of the 
%element file.


%This function will create the element files for the K'Nex structure, it includes:
% element number, node1, node2,  and (cross sectional area & Young's Modulus - optional)
%*************************************************************************************************************************************
%ELEMENT FILES
%*************************************************************************************************************************************

YM = 10e5;
Area = 0.5*0.5; %cm^2

%ELEMENT FILES FOR SQUARE GRID% 
%horizontal lines
NELEM = 0;
for j = 1:(Ny),
    for i = 1:Ex,
        NELEM = NELEM + 1;       
        elem(NELEM,1) = NELEM;              %element number
        elem(NELEM,2) = (j-1)*Nx + i;       % node 1 
        elem(NELEM,3) = (j-1)*Nx + i+1;     % node 2 
        elem(NELEM,4) = Area;               % cross sectional area
        elem(NELEM,5) = YM;                 % Young's Modulus
        elem(NELEM,6) = 0;						  %if it exists
        elem(NELEM,7) = Lb;				     %the length of the element
     end
end

%vertical lines
for j = 1:Ey,
    for i = 1:(Nx),
        NELEM = NELEM + 1;       
        elem(NELEM,1) = NELEM ;             %element number
        elem(NELEM,2) = (j-1)*Nx + i;       % node 1 
        elem(NELEM,3) = (j-1)*Nx + i+Nx;    % node 2 
        elem(NELEM,4) = Area;               % cross sectional area
        elem(NELEM,5) = YM;                 % Young's Modulus
        elem(NELEM,6) = 0;							% if it exists
        elem(NELEM,7) = Lb;							%the length of the element
    end
end

%ELEMENT FILES FOR DIAGONALS%
%lower left to middle

for j = 1:Ey,
    for i = 1:Ex,
        NELEM = NELEM + 1;       
        elem(NELEM,1) = NELEM;                              %element number
        elem(NELEM,2) = (j-1)*Nx + i;                       % node 1 
        elem(NELEM,3) = NSQUARENODE + ((j-1)*Ex+i);         % node 2 
        elem(NELEM,4) = Area;                               % cross sectional area
        elem(NELEM,5) = YM;                                 % Young's Modulus
        elem(NELEM,6) = 0;												% if it exists
        elem(NELEM,7) = Lw;											%the length of the element

     end
end

%lower right to middle
for j = 1:Ey,
    for i = 1:Ex,
        NELEM = NELEM + 1;       
        elem(NELEM,1) = NELEM;                              %element number
        elem(NELEM,2) = (j-1)*Nx + i +1;                    % node 1 
        elem(NELEM,3) = NSQUARENODE + ((j-1)*Ex+i);         % node 2  
        elem(NELEM,4) = Area;                               % cross sectional area
        elem(NELEM,5) = YM;                                 % Young's Modulus
        elem(NELEM,6) = 0;												%if it exists
        elem(NELEM,7) = Lw;											%the length of the element
    end
end

%upper right to middle
for j = 1:Ey,
    for i = 1:Ex,
        NELEM = NELEM + 1;       
        elem(NELEM,1) = NELEM;                              %element number
        elem(NELEM,2) = (j)*Nx + i +1;                      % node 1 
        elem(NELEM,3) = NSQUARENODE + ((j-1)*Ex+i);         % node 2  
        elem(NELEM,4) = Area;                               % cross sectional area
        elem(NELEM,5) = YM;                                % Young's Modulus
        elem(NELEM,6) = 0;												%if it exists
        elem(NELEM,7) = Lw;											%the length of the element
    end
end

%upper left to middle

for j = 1:Ey,
    for i = 1:Ex,
        NELEM = NELEM + 1;       
        elem(NELEM,1) = NELEM;                              %element number
        elem(NELEM,2) = (j)*Nx + i;                         % node 1 
        elem(NELEM,3) = NSQUARENODE + ((j-1)*Ex+i);         % node 2  
        elem(NELEM,4) = Area;                               % cross sectional area
        elem(NELEM,5) = YM;                                 % Young's Modulus
        elem(NELEM,6) = 0;												%if it exists
        elem(NELEM,7) = Lw;											%the length of the element
    end
end

% x and y coordinates of mid-points of the elements
for i = 1:NELEM,
   elem(i,8) = ( node(elem(i,2),2) + node(elem(i,3),2) ) / 2;  %x midpoint
   elem(i,9) = ( node(elem(i,2),3) + node(elem(i,3),3) ) / 2;  %y midpoint
end

exist = [ 2     3     4     5     6     7     8    10    11    12    13    14 ...
 15    16    17    18    59    60   113   150   203   240];
elem(exist,6) = 1;