function plotknex()
global Nx Ny Lb Lw Ex Ey s node elem NNODES NELEM NSQUARENODE ElemBoxCoords Lx Ly flag SE U

if flag == 1,
   flag = -flag;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%plot elements
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
axis equal
%plot square elements in blue   
for i = 1:(Nx-1)*Ny + (Ny-1)*Nx, % goes through all elements up to the last square elem
	node1 = elem(i,2);
	node2 = elem(i,3);
                
%the next line checks to see if the element exists (hasn't been removed)
	if (elem(i,6) ~= 0)
		plot([node(node1,2) node(node2,2)], [node(node1,3) node(node2,3)],'Color',[0.2 0 0.8]);
	end
end

%plot diagonal elements in white   
for i = (Nx-1)*Ny + (Ny-1)*Nx + 1:1:NELEM, % goes through all diagonal elements
	node1 = elem(i,2);
	node2 = elem(i,3);
                
%the next line checks to see if the element exists (hasn't been removed)
	if (elem(i,6) ~= 0)
	   plot([node(node1,2) node(node2,2)], [node(node1,3) node(node2,3)],'w');
	end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

c = .4; %radius of connectors

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%TYPE 1 CONNECTORS (white, 360 degrees)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Iex = find(elem(:,6)==1);
[U] = find (node(elem(Iex(:,1),2),4)==1); %node1s that exist and are type 1
[P] = find (node(elem(Iex(:,1),3),4)==1); %node2s that exist and are type 1


for i = 1:size(U,1),
	x = node(elem(Iex(U(i,1),1),2),2);
	y = node(elem(Iex(U(i,1),1),2),3);
	t = node(elem(Iex(U(i,1),1),2),5)*pi/180; % angle of connector

%if type == 1
    sqx = [x+c*cos(.125*pi+t) x+c*cos(.375*pi+t) x+c*cos(.625*pi+t) x+c*cos(.875*pi+t) x+c*cos(1.125*pi+t) x+c*cos(1.375*pi+t) x+c*cos(1.625*pi+t) x+c*cos(1.875*pi+t) x+c*cos(.125*pi+t)];
    sqy = [y+c*sin(.125*pi+t) y+c*sin(.375*pi+t) y+c*sin(.625*pi+t) y+c*sin(.875*pi+t) y+c*sin(1.125*pi+t) y+c*sin(1.375*pi+t) y+c*sin(1.625*pi+t) y+c*sin(1.875*pi+t) y+c*sin(.125*pi+t)];
    fill(sqx,sqy,'w');

    h1 = plot([x x+2*c*cos(.25*pi+t)],[y y+2*c*sin(.25*pi+t)], '-w');
    set(h1,'LineWidth',2);

    h2 = plot([x x+2*c*cos(.5*pi+t)],[y y+2*c*sin(.5*pi+t)], '-w');
    set(h2,'LineWidth',2);
    
    h3 = plot([x x+2*c*cos(.75*pi+t)],[y y+2*c*sin(.75*pi+t)], '-w');
    set(h3,'LineWidth',2);

    h4 = plot([x x+2*c*cos(pi+t)],[y y+2*c*sin(pi+t)], '-w');
    set(h4,'LineWidth',2);
    
    h5 = plot([x x+2*c*cos(1.25*pi+t)],[y y+2*c*sin(1.25*pi+t)], '-w');
    set(h5,'LineWidth',2);

    h6 = plot([x x+2*c*cos(1.5*pi+t)],[y y+2*c*sin(1.5*pi+t)], '-w');
    set(h6,'LineWidth',2);
    
    h7 = plot([x x+2*c*cos(1.75*pi+t)],[y y+2*c*sin(1.75*pi+t)], '-w');
    set(h7,'LineWidth',2);

    h8 = plot([x x+2*c*cos(2*pi+t)],[y y+2*c*sin(2*pi+t)], '-w');
    set(h8,'LineWidth',2);
end
for i = 1:size(P,1),
	x = node(elem(Iex(P(i,1),1),3),2);
	y = node(elem(Iex(P(i,1),1),3),3);
	t = node(elem(Iex(P(i,1),1),3),5)*pi/180; % angle of connector

%if type == 1
    sqx = [x+c*cos(.125*pi+t) x+c*cos(.375*pi+t) x+c*cos(.625*pi+t) x+c*cos(.875*pi+t) x+c*cos(1.125*pi+t) x+c*cos(1.375*pi+t) x+c*cos(1.625*pi+t) x+c*cos(1.875*pi+t) x+c*cos(.125*pi+t)];
    sqy = [y+c*sin(.125*pi+t) y+c*sin(.375*pi+t) y+c*sin(.625*pi+t) y+c*sin(.875*pi+t) y+c*sin(1.125*pi+t) y+c*sin(1.375*pi+t) y+c*sin(1.625*pi+t) y+c*sin(1.875*pi+t) y+c*sin(.125*pi+t)];
    fill(sqx,sqy,'w');

    h1 = plot([x x+2*c*cos(.25*pi+t)],[y y+2*c*sin(.25*pi+t)], '-w');
    set(h1,'LineWidth',2);

    h2 = plot([x x+2*c*cos(.5*pi+t)],[y y+2*c*sin(.5*pi+t)], '-w');
    set(h2,'LineWidth',2);
    
    h3 = plot([x x+2*c*cos(.75*pi+t)],[y y+2*c*sin(.75*pi+t)], '-w');
    set(h3,'LineWidth',2);

    h4 = plot([x x+2*c*cos(pi+t)],[y y+2*c*sin(pi+t)], '-w');
    set(h4,'LineWidth',2);
    
    h5 = plot([x x+2*c*cos(1.25*pi+t)],[y y+2*c*sin(1.25*pi+t)], '-w');
    set(h5,'LineWidth',2);

    h6 = plot([x x+2*c*cos(1.5*pi+t)],[y y+2*c*sin(1.5*pi+t)], '-w');
    set(h6,'LineWidth',2);
    
    h7 = plot([x x+2*c*cos(1.75*pi+t)],[y y+2*c*sin(1.75*pi+t)], '-w');
    set(h7,'LineWidth',2);

    h8 = plot([x x+2*c*cos(2*pi+t)],[y y+2*c*sin(2*pi+t)], '-w');
    set(h8,'LineWidth',2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%TYPE 2 CONNECTORS (yellow, 180 degrees)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Iex = find(elem(:,6)==1);
[U] = find (node(elem(Iex(:,1),2),4)==2); %node1s that exist and are type 2
[P] = find (node(elem(Iex(:,1),3),4)==2); %node2s that exist and are type 2

for i = 1:size(U,1),
	x = node(elem(Iex(U(i,1),1),2),2);
	y = node(elem(Iex(U(i,1),1),2),3);
   t = node(elem(Iex(U(i,1),1),2),5)*pi/180; % angle of connector
   
    sqx = [x+c*cos(.125*pi+t) x+c*cos(.875*pi+t) x+c*cos(1.125*pi+t) x+c*cos(1.375*pi+t) x+c*cos(1.625*pi+t) x+c*cos(1.875*pi+t) x+c*cos(.125*pi+t)];
    sqy = [y+c*sin(.125*pi+t) y+c*sin(.875*pi+t) y+c*sin(1.125*pi+t) y+c*sin(1.375*pi+t) y+c*sin(1.625*pi+t) y+c*sin(1.875*pi+t) y+c*sin(.125*pi+t)];
    fill(sqx,sqy,'y');

    h4 = plot([x x+2*c*cos(pi+t)],[y y+2*c*sin(pi+t)], '-y');
    set(h4,'LineWidth',2);
    
    h5 = plot([x x+2*c*cos(1.25*pi+t)],[y y+2*c*sin(1.25*pi+t)], '-y');
    set(h5,'LineWidth',2);

    h6 = plot([x x+2*c*cos(1.5*pi+t)],[y y+2*c*sin(1.5*pi+t)], '-y');
    set(h6,'LineWidth',2);
    
    h7 = plot([x x+2*c*cos(1.75*pi+t)],[y y+2*c*sin(1.75*pi+t)], '-y');
    set(h7,'LineWidth',2);

    h8 = plot([x x+2*c*cos(2*pi+t)],[y y+2*c*sin(2*pi+t)], '-y');
    set(h8,'LineWidth',2);
end
for i = 1:size(P,1),
	x = node(elem(Iex(P(i,1),1),3),2);
	y = node(elem(Iex(P(i,1),1),3),3);
   t = node(elem(Iex(P(i,1),1),3),5)*pi/180; % angle of connector
   
    sqx = [x+c*cos(.125*pi+t) x+c*cos(.875*pi+t) x+c*cos(1.125*pi+t) x+c*cos(1.375*pi+t) x+c*cos(1.625*pi+t) x+c*cos(1.875*pi+t) x+c*cos(.125*pi+t)];
    sqy = [y+c*sin(.125*pi+t) y+c*sin(.875*pi+t) y+c*sin(1.125*pi+t) y+c*sin(1.375*pi+t) y+c*sin(1.625*pi+t) y+c*sin(1.875*pi+t) y+c*sin(.125*pi+t)];
    fill(sqx,sqy,'y');

    h4 = plot([x x+2*c*cos(pi+t)],[y y+2*c*sin(pi+t)], '-y');
    set(h4,'LineWidth',2);
    
    h5 = plot([x x+2*c*cos(1.25*pi+t)],[y y+2*c*sin(1.25*pi+t)], '-y');
    set(h5,'LineWidth',2);

    h6 = plot([x x+2*c*cos(1.5*pi+t)],[y y+2*c*sin(1.5*pi+t)], '-y');
    set(h6,'LineWidth',2);
    
    h7 = plot([x x+2*c*cos(1.75*pi+t)],[y y+2*c*sin(1.75*pi+t)], '-y');
    set(h7,'LineWidth',2);

    h8 = plot([x x+2*c*cos(2*pi+t)],[y y+2*c*sin(2*pi+t)], '-y');
    set(h8,'LineWidth',2);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%TYPE 3 CONNECTORS (red, 90 degrees)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Iex = find(elem(:,6)==1);
[U] = find (node(elem(Iex(:,1),2),4)==3); %node1s that exist and are type 3
[P] = find (node(elem(Iex(:,1),3),4)==3); %node2s that exist and are type 3

for i = 1:size(U,1),
	x = node(elem(Iex(U(i,1),1),2),2);
	y = node(elem(Iex(U(i,1),1),2),3);
	t = node(elem(Iex(U(i,1),1),2),5)*pi/180; % angle of connector
    sqx = [x+c*cos(.125*pi+t) x+c*(sin(.125*pi)/sin(.25*pi))*cos(.75*pi+t) x+c*cos(1.375*pi+t) x+c*cos(1.625*pi+t) x+c*cos(1.875*pi+t) x+c*cos(.125*pi+t)];
    sqy = [y+c*sin(.125*pi+t) y+c*(sin(.125*pi)/sin(.25*pi))*sin(.75*pi+t) y+c*sin(1.375*pi+t) y+c*sin(1.625*pi+t) y+c*sin(1.875*pi+t) y+c*sin(.125*pi+t)];
    fill(sqx,sqy,'r');

    h6 = plot([x x+2*c*cos(1.5*pi+t)],[y y+2*c*sin(1.5*pi+t)], '-r');
    set(h6,'LineWidth',2);
    
    h7 = plot([x x+2*c*cos(1.75*pi+t)],[y y+2*c*sin(1.75*pi+t)], '-r');
    set(h7,'LineWidth',2);

    h8 = plot([x x+2*c*cos(2*pi+t)],[y y+2*c*sin(2*pi+t)], '-r');
    set(h8,'LineWidth',2);
end
for i = 1:size(P,1),
	x = node(elem(Iex(P(i,1),1),3),2);
	y = node(elem(Iex(P(i,1),1),3),3);
	t = node(elem(Iex(P(i,1),1),3),5)*pi/180; % angle of connector
    sqx = [x+c*cos(.125*pi+t) x+c*(sin(.125*pi)/sin(.25*pi))*cos(.75*pi+t) x+c*cos(1.375*pi+t) x+c*cos(1.625*pi+t) x+c*cos(1.875*pi+t) x+c*cos(.125*pi+t)];
    sqy = [y+c*sin(.125*pi+t) y+c*(sin(.125*pi)/sin(.25*pi))*sin(.75*pi+t) y+c*sin(1.375*pi+t) y+c*sin(1.625*pi+t) y+c*sin(1.875*pi+t) y+c*sin(.125*pi+t)];
    fill(sqx,sqy,'r');

    h6 = plot([x x+2*c*cos(1.5*pi+t)],[y y+2*c*sin(1.5*pi+t)], '-r');
    set(h6,'LineWidth',2);
    
    h7 = plot([x x+2*c*cos(1.75*pi+t)],[y y+2*c*sin(1.75*pi+t)], '-r');
    set(h7,'LineWidth',2);

    h8 = plot([x x+2*c*cos(2*pi+t)],[y y+2*c*sin(2*pi+t)], '-r');
    set(h8,'LineWidth',2);
 end   
else  
   cla
   gridplot2
end





