%%%%  MAIN CODE FOR TRUSS OPTIMIZATION  %%%%
clc;
clear all;
load('trussdata.mat');
tol = 1e-5;  % Tolerance for checking for convergence
Le = Length;
Ae = ones(1,NELEM);
Amax = 15; %Maximum allowed elementsa area of truss member
Amin = 1e-6; %Minimum allowed elementsa area of truss member
Ve = Ae.*Le;
vstar = 35; %Maximum material available

%% Force and Boundary Conditions
F = zeros(2*NNODE,1);
F(10,1) = -2e4;
dispID = [1 2 11 12 21 22 31 32 41 42];
% F(6,1) = -2e4;
% dispID = [1 2 10 11];

% dispID = [1 2 11 12 21 22 31 32 41 42 51 52 61 62 71 72 81 82 91 92];

dispVal = zeros(numel(dispID),1);

%% Adjoint Method Implementation
% [u,Rdisp,P,Ksing,SE,SEgrad] = femtruss(Ae, Le, Ee, nx, ny, ncon, NELEM, NNODE, F, dispID);

beta = 0.15;
its=1000; % Max number of iterations
history_A=zeros(NELEM,its+1); % Matrix to store values of Area after every iteration
history_A(:,1)=Ae(1,:);

for i=1:its
    lambda1=0;
   [u,Rdisp,P,Ksing,SE,SEgrad] = femtruss(Ae, Le, Ee, nx, ny, ncon, NELEM, NNODE, F, dispID);
   i

   for ie=1:NELEM
       
       eye = ncon(ie,1);
       jay = ncon(ie,2);
       L = Le(ie);
       A = Ae(ie);
       V = A*L;
       E = Ee(ie);
       lox = (nx(jay)-nx(eye))/L; mox = (ny(jay)-ny(eye))/L;
       loy = -mox; moy = lox;
       Lambda = [ lox mox  0  0    ; ...
           0   0  lox mox ];

       k_bar = [ 1 -1; -1 1 ];                     % Local element stiffness matrix
   
       k1 = k_bar*(A*E/L);
   
       klocal = Lambda' * k1 * Lambda;
       
       Ke = klocal;
       
       ue = [u(2*eye - 1) ; u(2*eye) ; u(2*jay - 1) ; u(2*jay)];
       
       SEe = ue' * Ke * ue;
       
       SEVe(ie) = SEe/V;
       
   end
   
    for j=1:NELEM
        lambda1=lambda1+Ae(j)*Le(j)*(SEVe(j))^beta;
    end
    lambda=(lambda1/vstar)^(1/beta);
    for j=1:NELEM
        Ae(j)=Ae(j)*(SEVe(j)/lambda)^beta;
    end
    flag=false;
    for j=1:NELEM
        if (Ae(j)>Amax)
            Ae(j)=Amax;
            flag=true;
        end
        if (Ae(j)<Amin)
            Ae(j)=Amin;
            flag=true;
        end
    end
    while flag
       [u,Rdisp,P,Ksing,SE,SEgrad] = femtruss(Ae, Le, Ee, nx, ny, ncon, NELEM, NNODE, F, dispID);

       for ie=1:NELEM
           eye = ncon(ie,1);
           jay = ncon(ie,2);
           
           L = Le(ie);
           A = Ae(ie);
           V = A*L;
           E = Ee(ie);
           lox = (nx(jay)-nx(eye))/L; mox = (ny(jay)-ny(eye))/L;
           loy = -mox; moy = lox;
           Lambda = [ lox mox  0  0    ; ...
               0   0  lox mox ];
           
           
           k_bar = [ 1 -1; -1 1 ];                     % Local element stiffness matrix
           
           k1 = k_bar*(A*E/L);
           
           klocal = Lambda' * k1 * Lambda;
           
           Ke = klocal;
           
           ue = [u(2*eye - 1) ; u(2*eye) ; u(2*jay - 1) ; u(2*jay)];
           
           SEe = ue' * Ke * ue;
           
           SEVe(ie) = SEe/V;
           
       end
       
       upcount=0;lowcount=0;lambda1=0;
        Vup = 0;
        Vlow = 0;
        for j=1:NELEM
            if (Ae(j)==Amax)
                Vup = Ae(j)*Le(j);
                continue;
            end
            if (Ae(j)==Amin)
                Vlow = Ae(j)*Le(j);
                continue;
            end
            lambda1=lambda1+Ae(j)*Le(j)*(SEVe(j))^beta;
        end
        vstar1=vstar-(Vup + Vlow);
        lambda=(lambda1/vstar1)^(1/beta);
        for j=1:NELEM
            if Ae(j)~=Amax && Ae(j)~=Amin
                Ae(j)=Ae(j)*(SEVe(j)/lambda)^beta;
            end
        end
        flag=false;
        for j=1:NELEM
            if (Ae(j)>Amax)
                Ae(j)=Amax;
                flag=true;
            end
            if (Ae(j)<Amin)
                Ae(j)=Amin;
                flag=true;
            end
        end
    end
    history_A(:,i+1)=Ae(1,:);
    
    % Check for convergence
    
    tolcheck=max(abs(history_A(:,i+1)-history_A(:,i)));
    k=i;
    if tolcheck<=tol
        break;
    end
end

Ae = (history_A(:,k+1))';

j = 1;
for i = 1:NELEM
    
    if Ae(i) >= 1e-3
             NCON(j,:) = ncon(i,:);
             AE(j) = Ae(i);
             j = j+1;
    end
    
end

%% PLOTING THE OPTIMIZED STRUCTURE

[NELEM1 NODE] = size(NCON);
for i = 1:NELEM1
    eye = NCON(i,1); jay = NCON(i,2);
    lw = AE(i);
    figure(2)
    hold on;
    plot([nx(eye) nx(jay)], [ny(eye) ny(jay)],'-k','linewidth',lw);
    hold on
end
