clc;clear all;
global Le F dispID Ee nx ny ncon NELEM NNODE Ve
load('trussdata.mat')

Le = Length;
Ae = ones(1,NELEM);
Amax = 15;
Amin = 1e-6;
Ve = Ae.*Le;
vstar = 35;
Ae2 = Ae;
Ve2 = Ve;
F = zeros(2*NNODE,1);
F(10,1) = -2e4;

dispID = [1 2 11 12 21 22 31 32 41 42];


dispVal = zeros(numel(dispID),1);

[u,Rdisp,P,Ksing,SE,SEgrad] = femtruss(Ae, Le, Ee, nx, ny, ncon, NELEM, NNODE, F, dispID);

Volume = 25;
A0 = Ae;
A_lb = 1e-6*ones(1,NELEM); % Lower bound on areas
A_ub = 15*ones(1,NELEM);
 C= Le;
options = optimset('Display','iter','MaxIter',700,'MaxFunEvals',10000, 'GradObj','on','DerivativeCheck','off','PlotFcns',@optimplotfval,'TolX',1e-10,'TolFun',1e-10);
[Area,fval,exitflag,output] = fmincon(@truss_obj_grad,A0,C,Volume,[],[],A_lb,A_ub,[],options);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ae = Area;
j = 1;
for i = 1:NELEM
    
    if Ae(i) >= 1e-1
             NCON(j,:) = ncon(i,:);
             AE(j) = Ae(i);
             j = j+1;
    end
    
end



[NELEM1 NODE] = size(NCON);
for i = 1:NELEM1
    eye = NCON(i,1); jay = NCON(i,2);
    lw = AE(i);
    figure(5)
    hold on;
    plot([nx(eye) nx(jay)], [ny(eye) ny(jay)],'-r','linewidth',lw);
    hold on
end
