function [obj, grad] = truss_obj_grad(Area)
global Le F dispID Ee nx ny ncon NELEM NNODE Ve

[u,Rdisp,P,Ksing,SE,SEgrad] = femtruss(Area, Le, Ee, nx, ny, ncon, NELEM, NNODE, F, dispID);

obj = F'*u;                       % Objective function

for ie=1:NELEM
  eye = ncon(ie,1);
  jay = ncon(ie,2);

  L = Le(ie);
  E = Ee(ie);
  lox = (nx(jay)-nx(eye))/L; mox = (ny(jay)-ny(eye))/L;
  loy = -mox; moy = lox;
  Lambda = [ lox mox  0  0    ; ...
              0   0  lox mox ];


  k = [ 1 -1; -1 1 ];                     % Local element stiffness matrix

  k = k*(E/L);

  ke = Lambda' * k * Lambda;
  
  ue = [u(2*eye - 1) ; u(2*eye) ; u(2*jay - 1) ; u(2*jay)];
  
  grad(1,ie) = -ue'*ke*ue;                % Gradient of the objective function
  
end
